//=============================================================================
// WeaponProd.
//=============================================================================
class WeaponProd extends DeusExWeapon;

var ProdEffect Shield;

event TravelPostAccept()
{
	Super.TravelPostAccept();
	if ( FiringMode ~= Automatic)
		FiringMode = AutoRefire;
}

function name WeaponDamageType()
{
        	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
		return 'Shocked';
        	else
                		return Super.WeaponDamageType();
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
                		PickupAmmoCount = 199;
                		ShotTime=0.700000;
                		InventoryGroup = 0;
                		return;
	}
        	if ( Level.Game.Difficulty == 3 )
		HitDamage = 10;
}

function ReloadAmmo()
{
}

function int ArmorAbsorbDamage(int Damage, name DamageType, vector HitLocation)
{
	local int ArmorDamage;

	if ( DamageType != 'Drowned' )
		ArmorImpactEffect(HitLocation);
	if ( DamageType =='EMP' )
		return 0;
	
	if (DamageType=='Drowned') Return Damage;
	
	ArmorDamage = (Damage * ArmorAbsorption) / 100;

	return (Damage - ArmorDamage);
}

function ArmorImpactEffect(vector HitLocation)
{
        	local DeusExPlayer player;

        	player = DeusExPlayer(Owner);
   
        	if (player != None)
        	{
               		player.SetDamagePercent(Float(ArmorAbsorption)/100);
               		player.ClientFlash(0.01, vect(0, 0, 100));
        	}
	PlaySimSound( Misc2Sound, SLOT_None, TransientSoundVolume, 1024 );
}

function AltFire(float Value)
{
	local float sndVolume;
	local bool bListenClient;

	bListenClient = (Owner.IsA('DeusExPlayer') && DeusExPlayer(Owner).PlayerIsListenClient());

	sndVolume = TransientSoundVolume;	

        	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
             		sndVolume = TransientSoundVolume * 2.0;

        	if ( Level.NetMode != NM_Standalone )  
	{
		if ( !bClientReady && !bListenClient && Owner.IsA('DeusExPlayer'))
		{
                       		if ( Owner.IsA('DeusExPlayer')) 
				DeusExPlayer(Owner).bJustAltFired = False;
			bReadyToFire = True;
			bPointing = False;
			bFiring = False;
			return;
		}
	}
        		
	if (AmmoType.UseAmmo(1))
	{
	      	if (( Level.NetMode != NM_Standalone ) && (!bListenClient || !Owner.IsA('DeusExPlayer'))  )
		      	bClientReady = False;                 
		bFiring = True;
		bReadyToFire = False;
                      	if (( Level.NetMode != NM_Standalone ) && ((Owner != None) && !Owner.IsA('DeusExPlayer')))
                              		ClientAltFire(Value);
	      	GotoState('AltFiring');
		bPointing = True;
		if ( Owner.IsA('PlayerPawn') )
		    	PlayerPawn(Owner).PlayFiring();
		PlaySelectiveAltFiring();   
                      	if ( Owner.bHidden )
		    	CheckVisibility();
	}
	else
	      	PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		
	
	if (DeusExPlayer(Owner) != None)
	       	DeusExPlayer(Owner).UpdateBeltText(Self);
}

simulated function bool ClientAltFire( float value )
{
	local bool bWaitOnAnim;
	local vector shake;
	
	if ( !bLooping ) 
	{
		bWaitOnAnim = ( IsAnimating() && ((AnimSequence == 'Select') || (AnimSequence == 'Shoot') || (AnimSequence == 'ReloadBegin') || (AnimSequence == 'Reload') || (AnimSequence == 'ReloadEnd') || (AnimSequence == 'Down')));
	}
	else
	{
		bWaitOnAnim = False;
		bLooping = False;
	}
        	ServerForceAltFire();
	
	if (AmmoType.AmmoAmount > 0)
	{
		if ( AmmoType != None )
			AmmoType.SimUseAmmo();

		bFiring = True;
		bPointing = True;
		bClientReadyToFire = False;
		bInProcess = True;
		GotoState('ClientAltFiring');
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).PlayFiring();
		PlaySelectiveAltFiring();
        	}
	else
	{
	  	PlaySimSound( Misc1Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );		// play dry fire sound
	}
         	return true;
}

simulated function TraceAltFire( float Accuracy )
{
}

state AltFiring
{
        	function Tick( float DeltaTime )
	{
           		Global.Tick( DeltaTime );
	   	if ((Owner==None) || ((Pawn(Owner) != None) && (Pawn(Owner).bAltFire == 0))) 
           		{
			AmbientSound = None;
                			DestroyShield();
           		}
	}

        	function BeginState()
	{
                		bIsAnArmor = True;
                		AmbientSound = AltFireSound;
                		DrawShield();
		FiringMode = Automatic;
                		Super.BeginState();
	}	

	function EndState()
	{
                		bIsAnArmor = False;
                		AmbientSound = None;
                		DestroyShield();
		FiringMode = AutoRefire;
              		Super.EndState();
	}
}

simulated state ClientAltFiring
{
        	simulated function Tick( float DeltaTime )
	{
           		Global.Tick( DeltaTime );
	   	if ((Owner==None) || ((Pawn(Owner) != None) && (Pawn(Owner).bAltFire == 0))) 
           		{
			AmbientSound = None;
                			DestroyShield();
           		}
	}

        	simulated function BeginState()
	{
                		bIsAnArmor = True;
                		AmbientSound = AltFireSound;
                		DrawShield();
		FiringMode = Automatic;
                		Super.BeginState();
	}	

	simulated function EndState()
	{
                		bIsAnArmor = False;
                		AmbientSound = None;
                		DestroyShield();
		FiringMode = AutoRefire;
              		Super.EndState();
	}
}

simulated function DrawShield()
{
        	local Pawn p;

        	p = Pawn(Owner);

        	if ( p == None )
            		return;
  
        	if ( Shield == None )
        	{
             		Shield = Spawn(class'ProdEffect', p,, p.Location, p.Rotation );
             		if (Shield != None)
	     	{
			Shield.SetOwner(p);
                  		Shield.RemoteRole = ROLE_None;
	     	}
        	}
}

simulated function DestroyShield()
{
       	if ( Shield != None )
       	{
           		Shield.Destroy();
           		Shield = None;
       	}
}

simulated function Destroyed()
{
	DestroyShield();
	Super.Destroyed();
}

simulated function int AmmoLeftInClip()
{
	if (AmmoType == None)
		return 0;
	else
		return AmmoType.AmmoAmount;
}

simulated function int NumClips()
{
	return 0;
}

simulated function bool HasMaxClipMod()
{
	return (ModReloadCount == 1.5);
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
	     	return; 
	AmbientSound = None;
	DestroyShield();
	Super.DropFrom(StartLocation);
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local Pawn P;
	
	P = Pawn(Owner);

	if ( (P == None) || (P.Enemy == None) )
		return 0;

	EnemyDist = VSize(P.Enemy.Location - Owner.Location);
	if ( (EnemyDist < 750) && P.IsA('Bot') && Bot(P).bNovice && (P.Skill <= 2) && !P.Enemy.IsA('Bot') && (WeaponProd(P.Enemy.Weapon) != None) )
		return FClamp(300/(EnemyDist + 1), 0.6, 0.75);

	if ( EnemyDist > 250 )
		return 0.1;
	if ( (P.Weapon != self) && (EnemyDist < 120) )
		return 0.25;

        	if ( P.Enemy != None ) 
           		bUseAltMode = int( 240 < EnemyDist );
        	else
           		bUseAltMode = 0;
       
	return ( FMin(0.8, 81/(EnemyDist + 1)) );
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 0);
}

defaultproperties
{
     LowAmmoWaterMark=2
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     bAltAutomatic=True
     bAltSemiAuto=False
     ShotTime=1.000000
     ReloadSound=Sound'DeusExSounds.Weapons.ProdReloadEnd'
     FiringMode="AUTO-REFIRE"
     bTournamentWeapon=True
     Automatic="SHIELD"
     reloadTime=3.000000
     HitDamage=5
     maxRange=80
     AccurateRange=80
     bPenetrating=False
     StunDuration=10.000000
     bHasMuzzleFlash=False
     bFallbackWeapon=True
     bNeedToSetMPPickupAmmo=False
     mpReloadTime=3.000000
     mpHitDamage=100
     mpAccurateRange=120
     mpMaxRange=120
     mpReloadCount=199
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     msgInfoSingle="AUTO-REFIRE"
     AmmoName=Class'DeusEx.AmmoProd'
     ReloadCount=199
     PickupAmmoCount=20
     bInstantHit=True
     bAltInstantHit=True
     bMeleeWeapon=True
     FireOffset=(X=-21.000000,Y=12.000000,Z=19.000000)
     shakemag=20.000000
     RefireRate=0.980000
     AltRefireRate=0.990000
     FireSound=Sound'DeusExSounds.Weapons.ProdFire'
     AltFireSound=Sound'DeusEx.Weapons.ProdFire2'
     CockingSound=Sound'DeusExSounds.Weapons.ProdReload'
     SelectSound=Sound'DeusExSounds.Weapons.ProdSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.ProdReloadEnd'
     Misc2Sound=Sound'DeusEx.Effect.ProdArmorHit'
     ItemName="Riot Prod"
     PlayerViewOffset=(X=21.000000,Y=-12.000000,Z=-19.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Prod'
     PickupViewMesh=LodMesh'DeusExItems.ProdPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Prod3rd'
     ArmorAbsorption=75
     AbsorptionPriority=9
     Icon=Texture'DeusExUI.Icons.BeltIconProd'
     largeIcon=Texture'DeusExUI.Icons.LargeIconProd'
     largeIconWidth=49
     largeIconHeight=48
     Description="The riot prod has been extensively used by security forces who wish to keep what remains of the crumbling peace and have found the prod to be an valuable tool. Its short range tetanizing effect is most effective when applied to the torso or when the subject is taken by surprise. The prod also has the ability to resist and reflect incoming projectiles."
     beltDescription="PROD"
     Mesh=LodMesh'DeusExItems.ProdPickup'
     CollisionRadius=8.750000
     CollisionHeight=3.000000
}
