//=============================================================================
// WeaponRifle.
//=============================================================================
class WeaponRifle extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	        InventoryGroup = 6;
		bSemiAuto = False;
     		FiringMode = AutoRefire;
	        return;
	}

        if ( Level.Game.Difficulty == 3 )
        {
		HitDamage = mpHitDamage;
                ReloadTime = mpReloadTime;
		/*FireSound = ReloadedSound;*/
        }
}

function AltFire(float Value)
{
         	ClientAltFire(Value);
}

simulated function bool ClientAltFire(float Value)
{
         	ScopeToggle();
         	return true;
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        	local ShellCasing s;
        	local vector realLoc;

        	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
        	realLoc = Owner.Location + CalcDrawOffset();
        	s = Spawn(class'ShellCasing',, '', realLoc + 15 * X + (FireOffset.Y + 5) * Y + Z);
	if ( s != None )
               	{
		s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        	s.Velocity.Z += 200;
		s.DrawScale = 2.5;
		s.RemoteRole = ROLE_None;
        	}
}        

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        	if( !bHasSilencer )
        	{
                		MuzzleFlashLight();
                		if ( (PlayerPawn(Owner) != None)  
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                         		bMuzzleFlash++;   
        	}
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

	if ( Owner == None )
		return;
	
	if ( (flash != None) && !flash.bDeleteMe )
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if ( flash != None )
			flash.SetBase(Owner);
	}
}

simulated function bool HasMaxClipMod()
{
	return (ModReloadCount == 1.0);
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	bUseAltMode = 0;
	
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
       	return (BeltSpot == 6);
}

defaultproperties
{
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     NoiseLevel=1.500000
     EnviroEffective=ENVEFF_Air
     bSemiAuto=True
     ShotTime=0.600000
     ReloadSound=Sound'DeusExSounds.Weapons.RifleReloadEnd'
     ReloadedSound=Sound'DeusEx.Weapons.SniperFire'
     SilencedSound=Sound'DeusEx.Weapons.SilencedFire3'
     TimeBetweenFire=0.050000
     FiringMode="SEMI-AUTO"
     bTournamentWeapon=True
     reloadTime=2.000000
     HitDamage=30
     maxRange=48000
     AccurateRange=28800
     bCanHaveScope=True
     bHasScope=True
     bCanHaveLaser=True
     bCanHaveSilencer=True
     bHasMuzzleFlash=False
     recoilStrength=0.400000
     bUseWhileCrouched=False
     MinWeaponAcc=0.100000
     mpReloadTime=0.500000
     mpHitDamage=35
     mpAccurateRange=48000
     mpMaxRange=48000
     mpReloadCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="SEMI-AUTO"
     AmmoName=Class'DeusEx.Ammo3006'
     PickupAmmoCount=10
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(X=-20.000000,Y=2.000000,Z=30.000000)
     shakemag=50.000000
     AIRating=0.540000
     FireSound=Sound'DeusExSounds.Weapons.RifleFire'
     CockingSound=Sound'DeusExSounds.Weapons.RifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.RifleSelect'
     Misc2Sound=Sound'DeusExSounds.Special.Switch1Click'
     bDrawMuzzleFlash=True
     MuzzleScale=0.400000
     FlashY=0.035000
     FlashO=0.012500
     FlashC=0.030000
     FlashLength=0.010000
     FlashS=-32
     MFTexture=Texture'DeusEx.Skins.Muzzleflash03'
     AutoSwitchPriority=7
     InventoryGroup=14
     ItemName="Sniper Rifle"
     PlayerViewOffset=(X=20.000000,Y=-2.000000,Z=-30.000000)
     PlayerViewMesh=LodMesh'DeusExItems.SniperRifle'
     PickupViewMesh=LodMesh'DeusExItems.SniperRiflePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.SniperRifle3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconRifle'
     largeIcon=Texture'DeusExUI.Icons.LargeIconRifle'
     largeIconWidth=159
     largeIconHeight=47
     invSlotsX=4
     Description="The military sniper rifle is the superior tool for the interdiction of long-range targets. When coupled with the proven 30.06 round, a marksman can achieve tight groupings at better than 1 MOA (minute of angle) depending on environmental conditions."
     beltDescription="SNIPER"
     Mesh=LodMesh'DeusExItems.SniperRiflePickup'
     CollisionRadius=26.000000
     CollisionHeight=3.000000
     Mass=30.000000
}
