//=============================================================================
// WeaponRobotMachinegun.
//=============================================================================
class WeaponRobotMachinegun extends WeaponNPCRanged;

function name WeaponDamageType()
{
	return 'AutoShot';
}

simulated function bool ClientAltFire( float Value )
{
}

function AltFire( float Value )
{
}

simulated function SwapMuzzleFlashTexture()
{
   	if (!bHasMuzzleFlash)
      		return;  
	
	MultiSkins[2] = Texture'LaserSpot2';
	MuzzleFlashLight();  
	SetTimer(0.1, False);
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

      	if (Owner == None)
		return;
 	
	if ((flash != None) && !flash.bDeleteMe)
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if (flash != None)
		{
			flash.SetBase(Owner);
			flash.LightHue = 150;
			flash.LightSaturation = 32;
		}
	}
}

state NormalFire
{
        	function Tick( float DeltaTime )
	{
                		Global.Tick( DeltaTime );
		if ((Owner==None) || Owner.IsInState('Dying') || 
                   	    ((Level.NetMode != NM_StandAlone) && ((Pawn(Owner) != None) && (Pawn(Owner).bFire == 0)))) 
			AmbientSound = None;
	}

        	function BeginState()
	{
             		AmbientSound = FireSound;
                		Super.BeginState();
	}	

	function EndState()
	{
                		AmbientSound = None;
                		PlayEndFire();
               		Super.EndState();
	}
} 

simulated state ClientFiring
{
        	simulated function Tick( float DeltaTime )
	{
                		Global.Tick( DeltaTime );
	        	if ((Owner==None) || ((Pawn(Owner) != None) && (Pawn(Owner).bFire == 0))) 
			AmbientSound = None;
	}

        	simulated function BeginState()
	{
               		AmbientSound = FireSound;
		Super.BeginState();
	}	

	simulated function EndState()
	{
                		AmbientSound = None;
	                	PlayEndFire();
               		Super.EndState();
	}
}

simulated function PlayFiringSound()
{
}

simulated function PlayEndFire()
{
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume, 2048 );
}

simulated function Destroyed()
{
	AmbientSound = None;
	Super.Destroyed();
}

defaultproperties
{
     ShotTime=0.100000
     reloadTime=0.500000
     HitDamage=14
     BaseAccuracy=0.500000
     bHasMuzzleFlash=True
     AmmoName=Class'DeusEx.Ammo762mm'
     ReloadCount=100
     PickupAmmoCount=100
     bInstantHit=True
     AIRating=0.890000
     RefireRate=0.990000
     FireSound=Sound'DeusEx.Weapons.AssaultRifleFire2'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     Misc3Sound=Sound'DeusEx.Weapons.SilencedFire44'
     SoundRadius=96
     SoundVolume=255
}
