//=============================================================================
// WeaponRobotRocket.
//=============================================================================
class WeaponRobotRocket extends WeaponNPCRanged;

// fire weapons out of alternating sides
function Fire(float Value)
{
	PlayerViewOffset.Y = -PlayerViewOffset.Y;
	Super.Fire(Value);
}

simulated function bool ClientAltFire( float Value )
{
}

function AltFire( float Value )
{
}

state NormalFire
{
        	function Tick( float DeltaTime )
	{
                		Global.Tick( DeltaTime );
		if ((Owner==None) || Owner.IsInState('Dying') || 
                   	    ((Level.NetMode != NM_StandAlone) && ((Pawn(Owner) != None) && (Pawn(Owner).bFire == 0)))) 
			AmbientSound = None;
	}

        	function BeginState()
	{
             		AmbientSound = FireSound;
                		Super.BeginState();
	}	

	function EndState()
	{
                		AmbientSound = None;
                		PlayEndFire();
               		Super.EndState();
	}
} 

simulated state ClientFiring
{
        	simulated function Tick( float DeltaTime )
	{
                		Global.Tick( DeltaTime );
	        	if ((Owner==None) || ((Pawn(Owner) != None) && (Pawn(Owner).bFire == 0))) 
			AmbientSound = None;
	}

        	simulated function BeginState()
	{
               		AmbientSound = FireSound;
		Super.BeginState();
	}	

	simulated function EndState()
	{
                		AmbientSound = None;
	                	PlayEndFire();
               		Super.EndState();
	}
}

simulated function PlayFiringSound()
{
}

simulated function PlayEndFire()
{
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume, 2048 );
}

simulated function Destroyed()
{
	AmbientSound = None;
	Super.Destroyed();
}

function float RateSelf( out int bUseAltMode )
{
	local float ads;
	local DeusExPlayer E;

	bUseAltMode = 0;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
		return AIRating;
	
	if ( Pawn(Owner).Enemy.IsA('DeusExPlayer') )
	{
		E = DeusExPlayer(Pawn(Owner).Enemy);
		if ( E.AugmentationSystem != None )
		{
			ads = E.AugmentationSystem.GetAugLevelValue(class'AugDefense');
			if ( ads >= 320.0 )
				return ( 0.88 + FRand() * 0.05 );
			else
				return AIRating;
		}
		else
			return ( AIRating + FRand() * 0.05 );
	}
	else					
		return ( AIRating + FRand() * 0.05 );
}

defaultproperties
{
     bAutomatic=True
     ShotTime=0.150000
     HitDamage=150
     AIMinRange=500.000000
     AIMaxRange=2000.000000
     AmmoName=Class'DeusEx.AmmoRocketRobot'
     PickupAmmoCount=20
     ProjectileClass=Class'DeusEx.RocketRobot'
     AIRating=0.980000
     RefireRate=0.850000
     FireSound=Sound'DeusEx.Weapons.MachineGunFire'
     Misc3Sound=Sound'DeusEx.Weapons.EndFire1'
     PlayerViewOffset=(Y=-46.000000,Z=36.000000)
     SoundRadius=96
     SoundVolume=255
}
