//=============================================================================
// WeaponRobotShockGun. 
//=============================================================================
class WeaponRobotShockGun extends WeaponNPCRanged;

simulated function bool ClientAltFire( float Value )
{
}

function AltFire( float Value )
{
}

simulated function MuzzleFlashLight()
{
	local Vector offset, X, Y, Z;

      	if (Owner == None)
		return;

 	if (!bHasMuzzleFlash)
		return;

	if ((flash != None) && !flash.bDeleteMe)
		flash.LifeSpan = flash.Default.LifeSpan;
	else
	{
		GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
		offset = Owner.Location;
		offset += X * Owner.CollisionRadius * 2;
		flash = spawn(class'MuzzleFlash',,, offset);
		if (flash != None)
		{
			flash.SetBase(Owner);
			flash.LightHue = 150;
			flash.LightSaturation = 32;
		}
	}
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;

	bUseAltMode = 0;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);

	if ( Pawn(Owner).Enemy.IsA('Robot') || Pawn(Owner).Enemy.IsA('CyborgDog') )
		return 0.97;
	/*else if ( (EnemyDist < 300) && (Enemy.Default.Health <= 100) )
		return 0.95;*/
	else					
		return ( AIRating + FRand() * 0.05 );
}

defaultproperties
{
     NoiseLevel=0.010000
     ShotTime=0.125000
     HitDamage=25
     maxRange=24000
     AccurateRange=14400
     AmmoName=Class'DeusEx.AmmoBattery'
     ReloadCount=50
     PickupAmmoCount=50
     ProjectileClass=Class'DeusEx.ShockBall'
     AIRating=0.810000
     RefireRate=0.900000
     FireSound=Sound'DeusEx.Weapons.PulseGunFire'
     SelectSound=Sound'DeusExSounds.Weapons.HideAGunSelect'
}
