//=============================================================================
// WeaponSMG
// There is no support for MP, Botmatch and Unrealistic difficulty!!!
//=============================================================================
class WeaponSMG extends DeusExWeapon;

var() class<ammo>	AltAmmoName;
var travel ammo		AltAmmoType;
var() int       	AltPickupAmmoCount;
var travel int		AltClipCount;
var travel byte		AltReloadCount;
var() int		AltHitDamage;
var() travel float	AltReloadTime;
var() Sound		AltReloadSound;
var() int		AltMaxRange;
var() travel int	AltAccurateRange;
var bool             	bHasShells;	

simulated function PreBeginPlay()
{
	bTournamentWeapon = False;
    	bDifficulty3 = False;
	FiringMode = "";
	Super.PreBeginPlay();
}

event TravelPostAccept()
{
	Super(Inventory).TravelPostAccept();
	if ( Pawn(Owner) == None )
		return;
	if ( AmmoName != None )
	{
		if ( AmmoType == None )
		{		
			AmmoType = Ammo(Pawn(Owner).FindInventoryType(AmmoName));
			if (AmmoType == None)
			{
				AmmoType = Spawn(AmmoName);	// Create ammo type required		
				Pawn(Owner).AddInventory(AmmoType);		// and add to player's inventory
				AmmoType.BecomeItem();
				AmmoType.AmmoAmount = PickUpAmmoCount; 
				AmmoType.GotoState('Idle2');
			}
		}
	}

        	if ( AltAmmoName != None )
	{
		if ( AltAmmoType == None )
		{		
			AltAmmoType = Ammo(Pawn(Owner).FindInventoryType(AltAmmoName));
			if (AltAmmoType == None)
			{
				AltAmmoType = Spawn(AltAmmoName);	// Create ammo type required		
				Pawn(Owner).AddInventory(AltAmmoType);		// and add to player's inventory
				AltAmmoType.BecomeItem();
				AltAmmoType.AmmoAmount = AltPickUpAmmoCount; 
				AltAmmoType.GotoState('Idle2');
			}
		}
	}       

	if ( self == Pawn(Owner).Weapon )
		BringUp();
	else GoToState('Idle2');

        	if (AmmoType != None)
		AmmoName = AmmoType.Class;

        	if (AltAmmoType != None)
		AltAmmoName = AltAmmoType.Class;

	if (!bAltInstantHit)
	{
		if (AltProjectileClass != None)
			AltProjectileSpeed = AltProjectileClass.Default.speed;
        	}
}

function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;
	local Weapon newWeapon;

	if( Level.Game.ShouldRespawn(self) )
	{
		Copy = spawn(Class,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;
		if ( !bWeaponStay )
			GotoState('Sleeping');
	}
	else
		Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.bTossedOut = false;

	WeaponSMG(Copy).GiveAmmo(Other);
        WeaponSMG(Copy).GiveAltAmmo(Other);
	Copy.GiveTo( Other );
	
	newWeapon = Weapon(Copy);
	newWeapon.Instigator = Other;
	if ( Level.Game.bDeathMatch || (Level.NetMode != NM_Standalone))
        	{
            		newWeapon.SetSwitchPriority(Other);
	    	if ( !Other.bNeverSwitchOnPickup )
			newWeapon.WeaponSet(Other);
        	}
        	newWeapon.AmbientGlow = 0;
	return newWeapon;
}

function GiveAltAmmo( Pawn Other )
{
	if ( AltAmmoName == None )
		return;
	AltAmmoType = Ammo(Other.FindInventoryType(AltAmmoName));
	if ( AltAmmoType != None )
		AltAmmoType.AddAmmo(AltPickUpAmmoCount);
	else
	{
		AltAmmoType = Spawn(AltAmmoName);		
		Other.AddInventory(AltAmmoType);		
		AltAmmoType.BecomeItem();
		AltAmmoType.AmmoAmount = AltPickUpAmmoCount; 
		AltAmmoType.GotoState('Idle2');
	}
}	

function bool HandlePickupQuery(Inventory Item)
{
	local WeaponSMG W;
        local Pawn PawnOwner;
	local class<Ammo> myAmmoClass;
	local Ammo myAmmo;
	
	W = WeaponSMG(Item);
	PawnOwner = Pawn(Owner);

	if (Item.Class == Class)
	{
           		if ( W.bWeaponStay && (!W.bHeldItem || W.bTossedOut) )
			return true;

		if ( AltAmmoType != None )
		{
			myAmmoClass = AltAmmoName;
			myAmmo = Ammo(PawnOwner.FindInventoryType(myAmmoClass));
			myAmmo.AddAmmo( WeaponSMG(Item).AltPickupAmmoCount );  	
		}
        	}
	return Super.HandlePickupQuery(Item);
}

simulated function PlayFiringSound()
{
}

simulated function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;

	// make noise if we are not silenced
	if ( !bHasSilencer )
	{
		GetAIVolume(volume, radius);
            		Owner.MakeNoise(Pawn(Owner).SoundDampening);
		Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
		Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
		if (!Owner.IsA('PlayerPawn'))
			Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	}

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2*AimError, False, False);
	
	if ( bLasing )
		Accuracy = FMax(tempAccuracy, MinWeaponAcc);

      	EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      	EndTrace += (FMax(1024.0, MaxRange) * vector(AdjustedAim));
      
      	Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		
	if ( (VSize(HitLocation - StartTrace) > 250) /*&& !bHasSilencer*/ )
	{
		rot = Rotator(EndTrace - StartTrace);
                Spawn(class'SniperTracer',,, Owner.Location + CalcDrawOffset() + (FireOffset.X)* X + (FireOffset.Y ) * Y + (FireOffset.Z) * Z * Vector(rot), rot);
	}
		
	dist = Abs(VSize(HitLocation - Owner.Location));

	if (dist <= AccurateRange)
		ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
	else if (dist <= MaxRange)
	{
		alpha = (dist - AccurateRange) / (MaxRange - AccurateRange);
		degrade = 0.5 * Square(alpha);
		HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
		ProcessTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
	}
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        local ShellCasing s;
        local vector realLoc;

        Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
        realLoc = Owner.Location + CalcDrawOffset();
        s = Spawn(class'ShellCasing',, '', realLoc + 10 * X + FireOffset.Y * Y + Z);
	if ( s != None )
        {
		s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        s.Velocity.Z += 200;
		s.DrawScale = 1.0;
		s.RemoteRole = ROLE_None;
        }
}        

state NormalFire
{
        function Tick( float DeltaTime )
	{
	        if ( (Owner == None) || Owner.IsInState('Dying') ) 
			AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        function BeginState()
	{
		if ( bHasSilencer )
			AmbientSound = SilencedSound;
		else
			AmbientSound = FireSound;
		Super.BeginState();
	}	

	function EndState()
	{
                AmbientSound = None;
                PlayEndFire();
               	Super.EndState();
	}
} 

simulated state ClientFiring
{
        simulated function Tick( float DeltaTime )
	{
	        if ( (Owner == None) || Owner.IsInState('Dying') ) 
			AmbientSound = None;
		Global.Tick( DeltaTime );
	}

        simulated function BeginState()
	{
                if ( bHasSilencer )
			AmbientSound = SilencedSound;
		else
			AmbientSound = FireSound;
		Super.BeginState();
	}	

	simulated function EndState()
	{
                AmbientSound = None;
	        PlayEndFire();
                Super.EndState();
	}
}   

simulated function PlayEndFire()
{
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume, 2048 );
}

simulated function TraceAltFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot;
	local actor Other;
	local float dist, alpha, degrade;
	local int i, numSlugs;
	local float volume, radius;

	GetAIVolume(volume, radius);
	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	Owner.AISendEvent('WeaponFire', EAITYPE_Audio, volume, radius);
	Owner.AISendEvent('LoudNoise', EAITYPE_Audio, volume, radius);
	if (!Owner.IsA('PlayerPawn'))
		Owner.AISendEvent('Distress', EAITYPE_Audio, volume, radius);
	
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = ComputeProjectileStart(X, Y, Z);
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, 2*AimError, False, False);

	numSlugs = 5;
	
	for (i=0; i<numSlugs; i++)
	{
      		Accuracy = MinAltSpreadAcc;     		
      		EndTrace = StartTrace + Accuracy * (FRand()-0.5)*Y*1000 + Accuracy * (FRand()-0.5)*Z*1000 ;
      		EndTrace += (FMax(1024.0, AltMaxRange) * vector(AdjustedAim));
      
      		Other = Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
		
		dist = Abs(VSize(HitLocation - Owner.Location));

		if (dist <= AltAccurateRange)
			ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		else if (dist <= AltMaxRange)
		{			
			alpha = (dist - AltAccurateRange) / (AltMaxRange - AltAccurateRange);
			degrade = 0.5 * Square(alpha);
			HitLocation.Z += degrade * (Owner.Location.Z - Owner.CollisionHeight);
			ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim),Y,Z);
		}
	}
}

simulated function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local float        mult;
	local name         damageType;
	local DeusExPlayer dxPlayer;
	local ShellCasing2 s;
        local vector realLoc;

	if (Other != None)
	{
		mult = 1.0;
		mult += -2.0 * GetWeaponSkill();
            	damageType = WeaponDamageType();

		if (Other != None)
		{
			if (Other.bOwned)
			{
				dxPlayer = DeusExPlayer(Owner);
				if (dxPlayer != None)
					dxPlayer.AISendEvent('Futz', EAITYPE_Visual);
			}
		}
		if ( (Other == Level) || (Other.IsA('Mover')) )
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(AltHitDamage * mult, Pawn(Owner), HitLocation, 50000*X, damageType);

			SpawnAltEffects( HitLocation, HitNormal, Other, AltHitDamage * mult);
		}
		else if ( (Other != self) && (Other != Owner) )
		{
			Other.TakeDamage(AltHitDamage * mult, Pawn(Owner), HitLocation, 50000*X, damageType);
                  				
			if ( Other.IsA('Pawn') && !Other.IsA('Robot') && !Other.IsA('CyborgDog') && !Other.IsA('HoloDenton') )
				SpawnBlood(HitLocation, HitNormal);
		}
	}
}

simulated function SpawnAltEffects(Vector HitLocation, Vector HitNormal, Actor Other, float Damage)
{
   	local TraceHitSpawner hitspawner;
	local Name damageType;

	damageType = WeaponDamageType();

   	hitspawner = Spawn(class'TraceHitSpawner3',Other,,HitLocation,Rotator(HitNormal));
			
   	if (hitSpawner != None)
	{
      		hitspawner.HitDamage = Damage;
		hitSpawner.damageType = damageType;
	}
}

simulated function EjectShell()
{
	local ShellCasing2 s;
        	local vector realLoc, X, Y, Z;
	local int i;

	if ( Owner == None )
		return;
	
	GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
	realLoc = Owner.Location + CalcDrawOffset();
        s = Spawn(class'ShellCasing2',, '', realLoc + 10 * X + FireOffset.Y * Y + Z);
	if ( s != None )
        {
		s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        s.Velocity.Z += 200;
		s.DrawScale = 0.7;
		s.RemoteRole = ROLE_None;
        }
	PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
}

function AltFire(float Value)
{
	local float sndVolume;
	
	sndVolume = TransientSoundVolume;
		
	if (Region.Zone.bWaterZone)
	{
		if (Pawn(Owner) != None)
		{
			Pawn(Owner).ClientMessage(msgNotWorking);
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		
		}
		GotoState('Idle');
		return;
	}

		
	if ( (AltReloadCount - AltClipCount) >= AmmoPerAltFire )
	{
		if ( AltAmmoType.UseAmmo(AmmoPerAltFire) )
		{
			AltClipCount += AmmoPerAltFire;
			bFiring = True;
			bReadyToFire = False;                       		
                        GotoState('AltFiring');
			bPointing=True;
                  	TraceAltFire(currentAccuracy + AltAccuracy);			
			if ( Owner.IsA('PlayerPawn') )
				PlayerPawn(Owner).PlayFiring();
			PlaySelectiveAltFiring();   
			PlayFiringAltSound();
			if ( Owner.bHidden )
				CheckVisibility();
			EjectShell();
		}
		else
			PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		
	}
	else
		PlaySimSound( Misc1Sound, SLOT_None, sndVolume, 1024 );		

	if (DeusExPlayer(Owner) != None)
		DeusExPlayer(Owner).UpdateBeltText(Self);
}

simulated function int AmmoLeftInAltClip()
{
	if (AltAmmoType.AmmoAmount == 0)		
		return 0;
	else if (AltReloadCount - AltClipCount > AltAmmoType.AmmoAmount)
		return AmmoType.AmmoAmount;
	else
		return AltReloadCount - AltClipCount;
}

simulated function PlaySelectiveAltFiring()
{
	Super.PlaySelectiveAltFiring();
        if ((PlayerPawn(Owner) != None)  
	&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
	MuzzleFlashLight();   
}

simulated function PlayFiringAltSound()
{
	PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume, 2048 );
}

state AltFiring
{
	function SwapMuzzleFlashTexture()
        {
        }
	
Begin:
	if ( AmmoLeftInAltClip() < AmmoPerAltFire )
	{
		bFiring = False;
		FinishAnim();
		
		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;
				
				if (DeusExPlayer(Owner).bAutoReload)
					CycleAmmo();
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				CycleAmmo();
			}

                  	else if (Bot(Owner) != None)
			{
				bFiring = False;
                       		CycleAmmo();
			}
		}
		else
		{
			if (bHasMuzzleFlash)
				EraseMuzzleFlashTexture();
			GotoState('Idle');
		}
	}
	
	Sleep(GetAltShotTime());	
	bFiring = False;
      	if ( !bAltSemiAuto )
        	FinishAnim();

	ReadyToFire();
Done:
	bFiring = False;
      	Finish();
}

function ReloadAmmo()
{	
	if ( (ClipCount == 0) || ((AmmoType.AmmoAmount - AmmoLeftInClip()) <= 0) )
    		return;
    
	if ( !IsInState('Reload') && !IsInState('AltReload') )
	{
		TweenAnim('Still', 0.1);
		GotoState('Reload');
	}
}

function CycleAmmo()
{
	
	if ( (AltClipCount == 0) || ((AltAmmoType.AmmoAmount - AmmoLeftInAltClip()) <= 0) )
    		return;
    
	if ( !IsInState('Reload') && !IsInState('AltReload') )
	{
		TweenAnim('Still', 0.1);
		GotoState('AltReload');
	}
}

state AltReload
{
	ignores Fire, AltFire;
	
	/*function Fire(float Value)
	{
		if ( Owner.IsA('DeusExPlayer') && ((Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch) )
		{
			Global.Fire(Value);
		}
		else
		{
			//Do nothing...
		}
	}

	function AltFire(float Value)
	{
		if ( Owner.IsA('DeusExPlayer') && ((Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch) )
		{
			Global.Fire(Value);
		}
		else
		{
			//Do nothing...
		}
	}*/

	function float GetAltReloadTime()
	{
		local float val;

		val = AltReloadTime;

		if ( ScriptedPawn(Owner) != None )
		{
                	if (Level.Game.Difficulty > 1)
                     		val = AltReloadTime/2;
                 	else
			   	val = AltReloadTime * (ScriptedPawn(Owner).BaseAccuracy*1+1);
			val = FMax(val, 0.4*AltReloadCount);
		}
            	else if (Bot(Owner) != None)
		{
			val = AltReloadTime/2.5;
			val = FMax(val, 0.4*AltReloadCount);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			val = GetWeaponSkill();
			val = AltReloadTime + (val*AltReloadTime);
			val = FMax(val, 0.4*AltReloadCount);
		}

		return val;
	}

	function NotifyOwner(bool bStart)
	{
		local DeusExPlayer player;
		local ScriptedPawn pawn;
            	local Bot aBot;

		player = DeusExPlayer(Owner);
		pawn   = ScriptedPawn(Owner);
            	aBot = Bot(Owner);

		if (player != None)
		{
			if (bStart)
				player.Reloading(self, GetAltReloadTime()+(1.0/AnimRate));
			else
			{
				player.DoneReloading(self);
			}
		}
		else if (pawn != None)
		{
			if (bStart)
				pawn.Reloading(self, GetAltReloadTime()+(1.0/AnimRate));
			else
				pawn.DoneReloading(self);
		}
            		else if (aBot != None)
		{
			if (bStart)
				aBot.Reloading(self, GetAltReloadTime()+(1.0/AnimRate));
			else
				aBot.DoneReloading(self);
		}

	}

	function BeginState()
	{
		if ( bHasLaser )
               			LaserOff();
	}

	function EndState()
	{
		if ( bHasLaser )
               			LaserOn();
	}
		
Begin:
	FinishAnim();

	if (AltAmmoType.AmmoAmount > 0)
	{
		Owner.PlaySound(CockingSound, SLOT_None,,, 1024);
		PlayAnim('ReloadBegin');
		NotifyOwner(True);
		FinishAnim();
LoadShell:
		if ( (AltClipCount > 0) && ((AltAmmoType.AmmoAmount - AmmoLeftInAltClip()) > 0) )
		{
			if ( AltClipCount == 1 )
				Owner.PlaySound(ReloadedSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
			else
				Owner.PlaySound(AltReloadSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
			AltClipCount--;
			LoopAnim('Reload');
			Sleep(GetAltReloadTime() / AltReloadCount);
			Goto 'LoadShell';
		} 
		else
		{
			PlayAnim('ReloadEnd');
			FinishAnim();
			NotifyOwner(False);
		}
	}
Done:
	GotoState('Idle');
}

function LoadAmmoType(Ammo ammo)
{
}

function LoadAmmoClass(Class<Ammo> ammoClass)
{
}

defaultproperties
{
     AltAmmoName=Class'DeusEx.AmmoShell'
     AltReloadCount=4
     AltHitDamage=8
     AltReloadTime=4.000000
     AltReloadSound=Sound'DeusEx.Weapons.ShotgunLoadShell'
     AltMaxRange=1600
     AltAccurateRange=800
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     ShotTime=0.100000
     AltShotTime=0.100000
     AIRating=0.610000
     ReloadSound=Sound'DeusEx.Weapons.UMPTacticalReloadEnd'
     ReloadedSound=Sound'DeusEx.Weapons.ShotgunReloaded'
     SilencedSound=Sound'DeusEx.Weapons.SilencedFire5'
     TimeBetweenFire=0.050000
     TimeBetweenAltFire=0.050000
     reloadTime=2.000000
     HitDamage=8
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=0.700000
     bCanHaveLaser=True
     bCanHaveSilencer=True
     AmmoNames(0)=Class'DeusEx.Ammo10mm'
     AmmoNames(1)=Class'DeusEx.AmmoShell'
     recoilStrength=0.700000
     MinAltSpreadAcc=0.100000
     MinWeaponAcc=0.250000
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="COMBINED"
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=30
     PickupAmmoCount=30
     bInstantHit=True
     bAltInstantHit=True
     bRapidFire=True
     FireOffset=(X=-16.000000,Y=-8.000000,Z=12.500000)
     shakemag=200.000000
     RefireRate=0.990000
     FireSound=Sound'DeusEx.Weapons.AssaultRifleFire3'
     AltFireSound=Sound'DeusEx.Weapons.UMPTacticalFire'
     CockingSound=Sound'DeusEx.Weapons.UMPTacticalReloadBegin'
     SelectSound=Sound'DeusEx.Weapons.UMPTacticalSelect'
     Misc2Sound=Sound'DeusExSounds.Special.Switch1Click'
     Misc3Sound=Sound'DeusEx.Weapons.SilencedFire44'
     bDrawMuzzleFlash=True
     MuzzleScale=0.500000
     FlashY=0.170000
     FlashO=0.010000
     FlashC=0.040000
     FlashLength=0.020000
     FlashS=128
     MFTexture=Texture'DeusEx.Skins.Muzzleflash03'
     InventoryGroup=222
     ItemName="Riot Sub-Machinegun"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusEx.umptactical1st'
     PickupViewMesh=LodMesh'DeusEx.umptacticalpickup'
     ThirdPersonMesh=LodMesh'DeusEx.umptactical3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusEx.Icons.UMP_belt'
     largeIcon=Texture'DeusEx.Icons.UMP_inv'
     largeIconWidth=128
     largeIconHeight=64
     invSlotsX=2
     invSlotsY=2
     Description="The riot sub-machinegun with shotgun add-on and sight features a double-barreled solution for advanced combat tactics and can be utilized to fire regular 10mm ammunition from the primary barrel and 12 gauge shotgun shells from the secondary barrel. The integrated sight also helps to increase the overall accuracy of the weapon."
     beltDescription="SMG"
     bDifficulty3=False
     Mesh=LodMesh'DeusEx.umptacticalpickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=15.000000
     CollisionHeight=2.100000
     Mass=30.000000
}
