//=============================================================================
// WeaponSawedOffShotgun.
//=============================================================================
class WeaponSawedOffShotgun extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		PickupAmmoCount = 24;
		InventoryGroup = 8;
		MomentumTransfer=10000;
           	return;
	}

       	if ( Level.Game.Difficulty == 3 )
	{
		ReloadTime = 2.000000;
	        HitDamage = mpHitDamage;
	}
}

simulated function bool ClientAltFire(float Value)
{
	if ( bBurst )
	{
		bBurst = False;
		FiringMode = SemiAuto;
		AmmoPerFire = 1;
		bSemiAuto = True;
		ShotTime = 0.1;
		AreaOfEffect = AOE_Cone;
		MinSpreadAcc = 0.2;
		TimeBetweenFire = 0.1;
		PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );	
        		return False; 
	}
	bBurst = True; 
	FiringMode = Burst;
	AmmoPerFire = 2;
	bSemiAuto = False;
	ShotTime = 0.3;
	AreaOfEffect = AOE_Sphere;
	MinSpreadAcc = 0.3;
	TimeBetweenFire = 0.05;
	PlaySimSound( Misc3Sound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
	return True;
}

function AltFire( float Value )
{
	ClientAltFire( Value );
}

simulated function PlayFiringSound()
{	
	if ( bBurst )
	{
		PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume, 1024 );
		SwapMuzzleFlashTexture();
	}
	else
	{
		EjectShell();
		PlaySimSound( FireSound, SLOT_None, TransientSoundVolume, 1024 );
		SwapMuzzleFlashTexture();
	}
}

simulated function EjectShell()
{
	local ShellCasing2 s;
        	local vector realLoc, X, Y, Z;
	local int i;

	if ( Owner == None )
		return;
	
	GetAxes(Pawn(Owner).ViewRotation, X, Y, Z);
	realLoc = Owner.Location + CalcDrawOffset();
        	for ( i=0; i<AmmoPerFire; i++ )
	{
        		s = Spawn(class'ShellCasing2',, '', realLoc + 4 * X + (FireOffset.Y + 5) * Y + (FireOffset.Z - 4) * Z);
		if ( s != None )
               		{
			s.Velocity = (FRand()*20+90) * Y + (10-FRand()*20) * X;
	        		s.Velocity.Z += 100;
			s.DrawScale = 0.7;
			s.RemoteRole = ROLE_None;
        		}
	}
	PlaySimSound( Misc2Sound, SLOT_None, 0.5, 1024 );
}

state NormalFire
{
	function AnimEnd()
	{
		Super.AnimEnd();
		if ( bBurst ) 
			EjectShell();
	}
}

simulated state ClientFiring
{
	simulated function AnimEnd()
	{
		Super.AnimEnd();
		if ( bBurst ) 
			EjectShell();
	}
}

function ReloadAmmo()
{  
	if ( !IsInState('Reload') )
	{
		TweenAnim('Still', 0.1);
		GotoState('Reload');
	}
}

state Reload
{
	ignores AltFire;

	function Fire(float Value)
	{
		if ( Owner.IsA('DeusExPlayer') && ((Level.NetMode == NM_Standalone) && !Level.Game.bDeathMatch) )
		{
			Global.Fire(Value);
		}
		else
		{
			//Do nothing...
		}
	}

	function float GetReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
                 			if (Level.Game.Difficulty > 1)
                     			val = ReloadTime/2;
                 			else
			   	val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*1+1);
			val = FMax(val, 0.4*ReloadCount);
		}
            		else if (Bot(Owner) != None)
		{
			val = ReloadTime/2.5;
			val = FMax(val, 0.4*ReloadCount);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
			val = FMax(val, 0.4*ReloadCount);
		}

		return val;
	}		
Begin:
	FinishAnim();

	if (AmmoType.AmmoAmount > 0)
	{
		if ( ((Level.NetMode == NM_DedicatedServer ) && Owner.IsA('DeusExPlayer')) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()))               
		{
				ClientReload();
				Sleep(GetReloadTime());
				ReadyClientToFire( True );
		}
		else
		{
			Owner.PlaySound(CockingSound, SLOT_None,,, 1024);
			PlayAnim('ReloadBegin');
			NotifyOwner(True);
			FinishAnim();
LoadShell:
			if ( (ClipCount > 0) && ((AmmoType.AmmoAmount - AmmoLeftInClip()) > 0) )
			{
				if ( ClipCount == 1 )
					Owner.PlaySound(ReloadedSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
				else
					Owner.PlaySound(ReloadSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
				ClipCount--;
				LoopAnim('Reload');
				Sleep(GetReloadTime() / ReloadCount);
				Goto 'LoadShell';
			} 
			else
			{
//				PlayAnim('ReloadEnd');
				ShotgunReloadEnd();
				FinishAnim();
				NotifyOwner(False);
			}
		}
	}
Done:
	GotoState('Idle');
}

simulated state SimReload
{	
	simulated function float GetSimReloadTime()
	{
		local float val;

		val = ReloadTime;

		if (ScriptedPawn(Owner) != None)
		{
                 			if ( Level.Game.Difficulty > 1 )
                     			val = ReloadTime/2;
                 			else
			   	val = ReloadTime * (ScriptedPawn(Owner).BaseAccuracy*1+1);
			val = FMax(val, 0.4*ReloadCount);
		}
            		else if (Bot(Owner) != None)
		{
			val = ReloadTime/2.5;
			val = FMax(val, 0.4*ReloadCount);
		}
		else if (DeusExPlayer(Owner) != None)
		{
			val = GetWeaponSkill();
			val = ReloadTime + (val*ReloadTime);
			val = FMax(val, 0.4*ReloadCount);
		}
		return val;
	}
Begin:
	if ( bWasInFiring )
	{		
		EraseMuzzleFlashTexture();
		FinishAnim();
	}
	bInProcess = False;
	bFiring=False;
      	
	Owner.PlaySound(CockingSound, SLOT_None,,, 1024);		
	PlayAnim('ReloadBegin');
	FinishAnim();
LoadShell:
	if ( (ClipCount > 0) && ((AmmoType.AmmoAmount - AmmoLeftInClip()) > 0) )
	{
		if ( ClipCount == 1 )
			Owner.PlaySound(ReloadedSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
		else
			Owner.PlaySound(ReloadSound, SLOT_None,,, 1024, 1.1 + 0.1*FRand());
		ServerDoneReloading();
		LoopAnim('Reload');
		Sleep(GetSimReloadTime() / ReloadCount);
		Goto 'LoadShell';
	} 
	else
	{
//		PlayAnim('ReloadEnd');
		ShotgunReloadEnd();
		FinishAnim();
	}
Done:
	GotoState('SimIdle');
}

function ServerDoneReloading()
{
	ClipCount--;
}

simulated function ShotgunReloadEnd()
{
  	if ( AmmoType.AmmoAmount > 0 ) 
	{
    		Owner.PlaySound(SelectSound, SLOT_None,,, 1024);
		PlayAnim('AltReloadEnd',,0.05);
	}
}

simulated function bool HasMaxClipMod()
{
	return (ModReloadCount == 0.4);
}

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
	{
		bUseAltMode = 0;
		return AIRating;
	}

	EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
	if ( (EnemyDist < 800) && (AmmoLeftInClip() >= AmmoPerFire) )
	{
		if ( EnemyDist < 400 )
		{
			if ( !bBurst )
				bUseAltMode = 1;
			else
				bUseAltMode = 0;
		}
		else
		{
			if ( !bBurst && (FRand() < 0.33) )
				bUseAltMode = 1;
			else
				bUseAltMode = 0;
		}
	}
	else 
	{
		if ( bBurst ) 
			bUseAltMode = 1;
		else
			bUseAltMode = 0;
	}
				
	return AIRating;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   	return (BeltSpot == 8);
}

defaultproperties
{
     LowAmmoWaterMark=8
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_Visual
     bSemiAuto=True
     ShotTime=0.100000
     ReloadSound=Sound'DeusEx.Weapons.ShotgunLoadShell'
     ReloadedSound=Sound'DeusEx.Weapons.ShotgunReloaded'
     FiringMode="SEMI-AUTO"
     MomentumTransfer=50000
     bTournamentWeapon=True
     Burst="PUMP-ACTION"
     reloadTime=4.000000
     HitDamage=8
     maxRange=3200
     AccurateRange=1600
     BaseAccuracy=0.000000
     AreaOfEffect=AOE_Cone
     recoilStrength=0.500000
     MinSpreadAcc=0.200000
     mpReloadTime=1.000000
     mpHitDamage=10
     mpAccurateRange=1600
     mpMaxRange=3200
     mpReloadCount=12
     mpPickupAmmoCount=24
     bCanHaveModReloadCount=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="SEMI-AUTO OR PUMP-ACTION BURST"
     AmmoName=Class'DeusEx.AmmoShell'
     ReloadCount=8
     PickupAmmoCount=8
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(X=-11.000000,Y=4.000000,Z=13.000000)
     shakemag=50.000000
     AIRating=0.520000
     RefireRate=0.850000
     FireSound=Sound'DeusEx.Weapons.ShotgunFire'
     AltFireSound=Sound'DeusEx.Weapons.ShotgunBurstFire'
     CockingSound=Sound'DeusExSounds.Weapons.SawedOffShotgunReload'
     SelectSound=Sound'DeusExSounds.Weapons.SawedOffShotgunSelect'
     Misc2Sound=Sound'DeusExSounds.Special.Switch1Click'
     Misc3Sound=Sound'DeusExSounds.Generic.DryFire'
     InventoryGroup=17
     ItemName="Riot Shotgun"
     PlayerViewOffset=(X=11.000000,Y=-4.000000,Z=-13.000000)
     PlayerViewMesh=LodMesh'DeusEx.Shotgun1'
     PickupViewMesh=LodMesh'DeusExItems.ShotgunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Shotgun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconShotgun'
     largeIcon=Texture'DeusExUI.Icons.LargeIconShotgun'
     largeIconWidth=131
     largeIconHeight=45
     invSlotsX=3
     Description="The riot shotgun (sometimes referred to as a 'street sweeper') is capable of firing both in a 'semi-auto' and a '2-round pupm-action burst' mode that can clear an area of hostiles in a matter of seconds. Particularly effective in urban combat, the riot shotgun accepts 12 gauge buckshot shells."
     beltDescription="SHOTGUN"
     Mesh=LodMesh'DeusExItems.ShotgunPickup'
     CollisionRadius=12.000000
     CollisionHeight=3.000000
     Mass=15.000000
}
