//=============================================================================
// WeaponStealthPistol.
//=============================================================================
class WeaponStealthPistol extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
		PickupAmmoCount = 60;
		InventoryGroup = 1;
		return;
	}
        	if ( Level.Game.Difficulty == 3 ) 
        	{
        		ReloadTime = mpReloadTime;
		BaseAccuracy = mpBaseAccuracy;
		MinWeaponAcc = 0.050000;
                		HitDamage = 14;
        	}
}

simulated event RenderOverlays( canvas Canvas )
{
        	Super.RenderOverlays(Canvas);
        	if ( bSteadyFlash3rd && !bSemiAuto )
	{
		bMuzzleFlash = 1;
		bSetFlashTime = false;
	}
	else
		bMuzzleFlash = 0;
}

simulated function bool ClientAltFire( float Value )
{
	if ( bSemiAuto && !bBurst )
	{
		bBurst = True;
		FiringMode = Burst;
		TimeBetweenFire = 0.010000;
		tempAccuracy = 0.050000;
		recoilStrength += 0.1;
		recoilStrength = FClamp(recoilStrength, 0.0, 0.3);
		PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
		return False; 
	}	

	if ( bSemiAuto && bBurst )
	{
		bSemiAuto = False;
		bBurst = False;
		FiringMode = Automatic;
		TimeBetweenFire = 0.020000;
		tempAccuracy = 0.200000;
		recoilStrength += 0.2;
		recoilStrength = FClamp(recoilStrength, 0.0, 0.5);
		PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
        	return False; 
	}
	bSemiAuto = True; 
	FiringMode = SemiAuto;
	TimeBetweenFire = 0.050000;
	tempAccuracy = 0.000000;
	recoilStrength -= 0.3;
	recoilStrength = FClamp(recoilStrength, 0.0, 0.2);
	PlaySimSound( AltFireSound, SLOT_None, TransientSoundVolume * 2.0, 1024 );
	return True;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

function DropFrom(vector StartLocation)
{
	if ( !SetLocation(StartLocation) )
	     	return; 
	ShotCount = 0;
	Super.DropFrom(StartLocation);
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
        	local ShellCasing s;
        	local vector realLoc;

        	Super.ProcessTraceHit(Other, HitLocation, HitNormal, X, Y, Z);
        	realLoc = Owner.Location + CalcDrawOffset();
        	s = Spawn(class'ShellCasing',, '', realLoc + 10 * X + FireOffset.Y * Y + Z);
		if ( s != None )
               	{
			s.Velocity = (FRand()*20+75) * Y + (10-FRand()*20) * X;
	        	s.Velocity.Z += 200;
			s.DrawScale = 1.5;
			s.RemoteRole = ROLE_None;
        	}
}        

function CycleAmmo()
{
}

state NormalFire
{   
	function float GetShotTime()
	{
                if ( bBurst )
			return 0.08;
                else
                	return ShotTime; 
	}      	

	function BeginState()
	{
       		bSteadyFlash3rd = true;
		Super.BeginState();
	}	

	function EndState()
	{
		bSteadyFlash3rd = false;
       		ShotCount = 0;
              	Super.EndState();
	}
Begin:
	if ( AmmoLeftInClip() < AmmoPerFire ) 
	{
		FinishAnim();
		
		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;

				if (DeusExPlayer(Owner).bAutoReload)
					ReloadAmmo();
				else
					GotoState('Idle');
			}

			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}

                        		else if (Bot(Owner) != None)
			{
				bFiring = False;
                                			ReloadAmmo();
			}
		}
		else
		{
			GotoState('Idle');
		}
	}
       	if ( bBurst && (ShotCount == 2) )
		Sleep(0.25);
	else
		Sleep(GetShotTime());
	bFiring = False;
        	if (!bSemiAuto && !bRapidFire)
                	FinishAnim();
	ReadyToFire();
Done:
	bFiring = False;
        	if ( bBurst && (ShotCount < 2) )
	{
		ShotCount++;
		Global.Fire(0.0);
	}
        	else
                		Finish();
}

simulated state ClientFiring
{
	simulated function float GetSimShotTime()
	{
		if ( bBurst )
			return 0.08;
                		else
                        		return ShotTime; 
	}        

	simulated function BeginState()
	{
              		bSteadyFlash3rd = true;
		Super.BeginState();
	}	

	simulated function EndState()
	{
                		bSteadyFlash3rd = false;
                		ShotCount = 0;
              		Super.EndState();
	}
Begin:
	if (AmmoLeftInClip() < AmmoPerFire) 
	{
		bFiring = False;
                		FinishAnim();

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;
				if (DeusExPlayer(Owner).bAutoReload)
				{
					bClientReadyToFire = False;
					bInProcess = False;
					ReloadAmmo();
					GotoState('SimQuickFinish');
				}
				else
				{
					IdleFunction();
					GotoState('SimQuickFinish');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
                                			bClientReadyToFire = False;
				bInProcess = False;
				bFiring = False;
                                			ReloadAmmo();
				GotoState('SimQuickFinish');
			}
                        		else if (Bot(Owner) != None)
			{
                                			bClientReadyToFire = False;
				bInProcess = False;
				bFiring = False;
                                			ReloadAmmo();
                                			GotoState('SimQuickFinish');
			}
		}
		else
		{
			IdleFunction();
			GotoState('SimQuickFinish');
		}
	}
        	if ( bBurst && (ShotCount == 2) )
		Sleep(0.25);
	else
        		Sleep(GetSimShotTime());
	bFiring = False;
        	if (!bSemiAuto && !bRapidFire) 
                	FinishAnim();
	bInProcess = False;
        	if ( (Owner != None) && !Owner.IsA('DeusExPlayer') )
                	ReadyClientToFire( True );
Done:
	bInProcess = False;
	bFiring = False;
	
	if ( bBurst && (ShotCount < 2) )
	{
		ShotCount++;
		ClientReFire(0.0);
	}
        	else
        		SimFinish();
}

function float RateSelf( out int bUseAltMode )
{
	if ( AmmoType.AmmoAmount <=0 )
		return -2;

        	if ( Region.Zone.bWaterZone )
		return  -2;

	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	if ( Pawn(Owner).IsA('Bot') )
	{
		if ( bSemiAuto && (FRand() < 0.5) )
			bUseAltMode = 1;
		else
			bUseAltMode = 0;
	}
	else
		bUseAltMode = 0;
					
	return AIRating;
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
        	return (BeltSpot == 1);
}

defaultproperties
{
     LowAmmoWaterMark=15
     GoverningSkill=Class'DeusEx.SkillWeaponPistol'
     NoiseLevel=0.010000
     EnviroEffective=ENVEFF_Air
     Concealability=CONC_All
     bSemiAuto=True
     ShotTime=0.100000
     AltShotTime=0.100000
     ReloadSound=Sound'DeusExSounds.Weapons.StealthPistolReloadEnd'
     TimeBetweenFire=0.050000
     FiringMode="SEMI-AUTO"
     bTournamentWeapon=True
     reloadTime=2.000000
     maxRange=4800
     AccurateRange=2400
     BaseAccuracy=0.700000
     bCanHaveLaser=True
     bHasSilencer=True
     bHasMuzzleFlash=False
     recoilStrength=0.200000
     mpReloadTime=0.500000
     mpHitDamage=10
     mpBaseAccuracy=0.300000
     mpAccurateRange=2400
     mpMaxRange=4800
     mpReloadCount=20
     bCanHaveModBaseAccuracy=True
     bCanHaveModReloadCount=True
     bCanHaveModAccurateRange=True
     bCanHaveModReloadTime=True
     bCanHaveModRecoilStrength=True
     msgInfoSingle="SEMI-AUTO, BURST OR FULL-AUTO"
     AmmoName=Class'DeusEx.Ammo10mm'
     ReloadCount=15
     PickupAmmoCount=15
     bInstantHit=True
     bAltInstantHit=True
     bRapidFire=True
     FireOffset=(X=-24.000000,Y=-2.000000,Z=4.000000)
     shakemag=5.000000
     shakevert=5.000000
     AIRating=0.240000
     RefireRate=0.950000
     FireSound=Sound'DeusExSounds.Weapons.StealthPistolFire'
     AltFireSound=Sound'DeusExSounds.Generic.DryFire'
     CockingSound=Sound'DeusExSounds.Weapons.StealthPistolReload'
     SelectSound=Sound'DeusExSounds.Weapons.StealthPistolSelect'
     Misc1Sound=Sound'DeusExSounds.Generic.DryFire'
     Misc3Sound=Sound'DeusEx.Weapons.SilencedFire44'
     bDrawMuzzleFlash=True
     MuzzleScale=3.000000
     FlashO=0.012500
     FlashC=0.100000
     FlashLength=1.000000
     FlashS=32
     MFTexture=FireTexture'Effects.Smoke.SmokePuff1'
     InventoryGroup=9
     ItemName="Stealth Pistol"
     PlayerViewOffset=(X=24.000000,Y=-10.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.StealthPistol'
     PickupViewMesh=LodMesh'DeusExItems.StealthPistolPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.StealthPistol3rd'
     Icon=Texture'DeusExUI.Icons.BeltIconStealthPistol'
     largeIcon=Texture'DeusExUI.Icons.LargeIconStealthPistol'
     largeIconWidth=47
     largeIconHeight=37
     Description="The stealth machine-pistol is a variant of the HMP-10 10mm pistol with a larger clip, semi-automatic, 3-round burst or full-automatic switchable firing capability and integrated silencer designed for wet work at very close ranges."
     beltDescription="STEALTH"
     Mesh=LodMesh'DeusExItems.StealthPistolPickup'
     SoundRadius=96
     SoundVolume=255
     CollisionRadius=8.000000
     CollisionHeight=3.000000
}
