//=============================================================================
// WeaponSuperPlasmaRifle.
//=============================================================================
class WeaponSuperPlasmaRifle extends DeusExWeapon;

simulated event RenderOverlays(canvas Canvas)
{
	local float Scale;
	local PlayerPawn P;
	local int OldClipX, OldClipY;

	Super.RenderOverlays(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) ) 
	{
		bZoomed = True;
		bOwnsCrossHair = True;
		OldClipX = Canvas.ClipX;
		OldClipY = Canvas.ClipY;
		Scale = FMax(0.5, int(Canvas.ClipX/640.0));
		Canvas.SetPos( 0.5 * OldClipX - 128 * Scale, 0.5 * OldClipY - 128 * Scale );
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawIcon(Texture'MyCross2', Scale);
		Canvas.SetPos(0.5 * OldClipX + 64 * Scale, 0.5 * OldClipY + 96 * Scale);
		Canvas.DrawColor.R = 0;
		Canvas.DrawColor.G = 255;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.Font = Canvas.MedFont;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
		Canvas.SetPos( 0, 0);
		Canvas.Style = ERenderStyle.STY_Modulated;
		Canvas.DrawIcon(Texture'VisionBlue', FMax(Canvas.ClipX, Canvas.ClipY));
	}	
	else
	{
		bZoomed = False;
		bOwnsCrossHair = False;				
	}
}


simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

simulated function PlaySelectiveFiring()
{
	Super.PlaySelectiveFiring();
        	if ((PlayerPawn(Owner) != None)  
	&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
                    	bMuzzleFlash++;   
}

simulated function TraceFire( float Accuracy )
{
	if ( ScriptedPawn(Owner) != None )
        	              	Accuracy += 1.5 + FRand();
	Super.TraceFire( Accuracy );
}

simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if ( Other == None )
	{
		HitNormal = -X;
		HitLocation = Owner.Location + X*10000.0;
	}

        	SpawnEffect(HitLocation, Owner.Location + CalcDrawOffset() + (FireOffset.X + 20) * X + FireOffset.Y * Y + FireOffset.Z * Z);
	Spawn(class'GreenSphere',,, HitLocation+HitNormal*8,rotator(HitNormal));
        
	if ( (Other != self) && (Other != Owner) && (Other != None) )             
        	{
                		if ( Role == ROLE_Authority )
	             		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 80000.0*X, 'SniperDeath');
        	}
}

simulated function SpawnEffect(vector HitLocation, vector SmokeLocation)
{
	local GreenBeam Smoke,shock;
	local Vector DVector;
	local int NumPoints;
	local rotator SmokeRotation;
	local LaserEmitter Rail;

	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/25.0;
	if ( NumPoints < 1 )
		return;
	SmokeRotation = rotator(DVector);
	SmokeRotation.roll = Rand(65535);

	Rail = Spawn(class'LaserEmitter',Self,,SmokeLocation,SmokeRotation);
	if (Rail != None)
	{
		Rail.AmbientSound = None;
		Rail.LifeSpan = 0.2;
		Rail.SetGreenBeam();
		Rail.TurnOn();
		if ( (Owner != None) && Owner.IsA('PlayerPawn') )
			Rail.RemoteRole = ROLE_None;
	}	
	
	Smoke = Spawn(class'GreenBeam',,,SmokeLocation,SmokeRotation);
	if ( Smoke != None )
	{
		Smoke.MoveAmount = DVector/NumPoints;
		Smoke.NumPuffs = NumPoints - 1;
		if ( (Owner != None) && Owner.IsA('PlayerPawn') )
			Smoke.RemoteRole = ROLE_None;
	}
}

state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( (Owner != None) && Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			if ( !bZoomed )
				PlaySimSound( Sound'ZoomIn', SLOT_Misc, 0.5, 1024 );
			else
				PlaySimSound( Sound'ZoomOut', SLOT_Misc, 0.5, 1024 );
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

function float RateSelf( out int bUseAltMode )
{
        	bUseAltMode = 0;       
        	return AIRating;
}

function ReloadAmmo()
{
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
     NoiseLevel=2.000000
     ShotTime=1.000000
     ReloadSound=Sound'DeusExSounds.Weapons.PlasmaRifleReloadEnd'
     AmmoPerFire=0
     FiringMode="INSTAGIB"
     bTournamentWeapon=True
     reloadTime=2.000000
     HitDamage=5000
     maxRange=48000
     AccurateRange=48000
     BaseAccuracy=0.000000
     bCanHaveScope=True
     bHasScope=True
     ScopeFOV=25
     bPenetrating=False
     bNeedToSetMPPickupAmmo=False
     mpAccurateRange=48000
     mpMaxRange=48000
     msgInfoSingle="AUTO-REFIRE"
     AmmoName=Class'DeusEx.AmmoSuperPlasma'
     ReloadCount=1
     PickupAmmoCount=1
     bInstantHit=True
     aimerror=550.000000
     shakemag=50.000000
     AIRating=2.500000
     RefireRate=0.700000
     FireSound=Sound'DeusEx.Weapons.SuperPlasmaFire'
     CockingSound=Sound'DeusExSounds.Weapons.PlasmaRifleReload'
     SelectSound=Sound'DeusExSounds.Weapons.PlasmaRifleSelect'
     bDrawMuzzleFlash=True
     MuzzleScale=1.000000
     FlashY=0.120000
     FlashO=0.022000
     FlashC=0.006000
     FlashS=128
     MFTexture=Texture'DeusEx.Effects.phit_a00'
     InventoryGroup=231
     ItemName="Enhanced Plasma Rifle"
     ItemArticle="the"
     PlayerViewOffset=(X=18.000000,Z=-7.000000)
     PlayerViewMesh=LodMesh'DeusExItems.PlasmaRifle'
     PlayerViewScale=0.750000
     PickupViewMesh=LodMesh'DeusExItems.PlasmaRiflePickup'
     ThirdPersonMesh=LodMesh'DeusExItems.PlasmaRifle3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconPlasmaRifle'
     Description="A classic and long-time favourite weapon of the true combatants."
     beltDescription="INSTAGIB"
     Mesh=LodMesh'DeusExItems.PlasmaRiflePickup'
     CollisionRadius=15.600000
     CollisionHeight=5.200000
     Mass=50.000000
}
