//=============================================================================
// WeaponSword.
//=============================================================================
class WeaponSword extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( ((Level.Game != None) && Level.Game.bDeathMatch) || (Level.NetMode != NM_Standalone) )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

simulated function bool ClientAltFire( float Value )
{
        	bClientReadyToFire = False;
        	bInProcess = True;
        	GotoState('ClientFiring');
        	bPointing = True;
        	if ( PlayerPawn(Owner) != None )
		PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
        	return true;		
}

function AltFire( float Value )
{
        	GotoState('AltFiring');
        	bPointing = True;
        	if ( Owner.IsA('PlayerPawn') )
		PlayerPawn(Owner).PlayFiring();
        	PlayFiringAltSound();
        	ProjectileAltFire(AltProjectileClass, AltProjectileSpeed, bAltWarnTarget);
        	if (HardcorePlayer(Owner) != None) 
             		HardcorePlayer(Owner).SwitchWeapon(0);
        	Destroy();
}

function bool HandlePickupQuery( inventory Item )
{
        	local DeusExPlayer P;

        	if ( Item.Class == Class )
        	{
             		P = DeusExPlayer(Owner);
             		if (P != None)
                 		P.ClientMessage(Sprintf(P.CanCarryOnlyOne, itemName));
	     	return true;
        	}
       	return Super.HandlePickupQuery(Item);
}

function Finish()
{
	if ( Level.NetMode != NM_Standalone )
		ReadyClientToFire( True );
		
	if ( bChangeWeapon )
	{
		GotoState('DownWeapon');
		return;
	}

	if ( (Level.NetMode != NM_Standalone ) && IsInState('Active') )
	{
		GotoState('Idle');
		return;
	}

	if (Pawn(Owner) == None)
	{
		GotoState('Idle');
		return;
	}
	if ( PlayerPawn(Owner) == None )
	{
		if ( (Pawn(Owner).bFire != 0) && (FRand() < RefireRate) )
			Global.Fire(0);
		else 
		{
			Pawn(Owner).StopFiring();
			GotoState('Idle');
		}
		return;
	}

	if ( ( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient()) )
	{
		GotoState('Idle');
		return;
	}

	if ( Pawn(Owner).Weapon != self )
		GotoState('Idle');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else 
		GotoState('Idle');
}

function float SuggestAttackStyle()
{
	return 10.0;
}

function float SuggestDefenseStyle()
{
	return -2.0;
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     AmmoPerFire=0
     AmmoPerAltFire=0
     FiringMode="MELEE"
     reloadTime=0.000000
     HitDamage=30
     maxRange=120
     AccurateRange=120
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=50
     mpBaseAccuracy=1.000000
     mpAccurateRange=150
     mpMaxRange=150
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     bAltWarnTarget=True
     bMeleeWeapon=True
     FireOffset=(X=-25.000000,Y=10.000000,Z=24.000000)
     AltProjectileClass=Class'DeusEx.Sword'
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.SwordFire'
     AltFireSound=Sound'DeusExSounds.Weapons.SwordFire'
     SelectSound=Sound'DeusExSounds.Weapons.SwordSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.SwordHitFlesh'
     Misc2Sound=Sound'DeusExSounds.Weapons.SwordHitHard'
     Misc3Sound=Sound'DeusExSounds.Weapons.SwordHitSoft'
     InventoryGroup=3
     ItemName="Sword"
     PlayerViewOffset=(X=25.000000,Y=-10.000000,Z=-24.000000)
     PlayerViewMesh=LodMesh'DeusExItems.Sword'
     PickupViewMesh=LodMesh'DeusExItems.SwordPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.Sword3rd'
     LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
     Icon=Texture'DeusExUI.Icons.BeltIconSword'
     largeIcon=Texture'DeusExUI.Icons.LargeIconSword'
     largeIconWidth=130
     largeIconHeight=40
     invSlotsX=3
     Description="A rather nasty-looking sword."
     beltDescription="SWORD"
     Texture=Texture'DeusExItems.Skins.ReflectionMapTex1'
     Mesh=LodMesh'DeusExItems.SwordPickup'
     CollisionRadius=26.000000
     CollisionHeight=3.000000
     Mass=20.000000
}
