//=============================================================================
// DXMapList.
//
// contains a list of maps to cycle through
//
//=============================================================================
class DXMapList extends Maplist;

var(Maps) globalconfig string Maps[64];
var globalconfig string MapSizes[64];
var globalconfig int MapNum;
var localized string CycleNames[10];
var int CycleType;
const MCT_STATIC = 0;
const MCT_RANDOM = 1;
const MCT_CYCLE = 2;
var int NumTypes;

var texture ScreenShot;
var String MapCreator;
var String MapName;



function string GetNextMap()
{
	local string CurrentMap;
  local int NumMaps;
	local int i;
  local DeusExLevelInfo DXmapinfo;

	CurrentMap = GetURLMap();
	if ( CurrentMap != "" )
	{
   		if ( Right(CurrentMap,3) ~= ".dx" )
			CurrentMap = Left(CurrentMap,Len(CurrentMap)-3);
		else
			CurrentMap = CurrentMap;
		  Screenshot = Texture(DynamicLoadObject(CurrentMap$".Screenshot", class'Texture'));
		for ( i=0; i<ArrayCount(Maps); i++ )
		{
			if ( CurrentMap ~= Maps[i] )
			{
				MapNum = i;
				break;
			}
		}
	}

        for (i = 0; ( (i < ArrayCount(Maps)) && (Maps[i] != "") ); i++);
        NumMaps = i;
        MapNum++;
        if (MapNum >= NumMaps)
        MapNum = 0;

        SaveConfig();
        return Maps[MapNum];
}

defaultproperties
{
     Maps(0)="DXHMP_TheTown"
     Maps(1)="DXHMP_NYCBar"
     Maps(2)="DXHMP_MetroStation"
     Maps(3)="DXHMP_Garage"
     Maps(4)="DXHMP_FreeClinic"
     Maps(5)="DXHMP_Station"
     Maps(6)="DXHMP_UnderGround"
     Maps(7)="DXHMP_AV_Start1"
     Maps(8)="DXHMP_AV_Memory_1"
     Maps(9)="DXHMP_AV_Memory_2"
     Maps(10)="DXHMP_AV_Memory_3"
     Maps(11)="dxhmp_AV_Memory_4"
     Maps(12)="DXHMP_AV_Memory_5"
     Maps(13)="DXHMP_AV_Delta"
     Maps(14)="DXHMP_AV_Delta_ENL"
     Maps(15)="DXHMP_AV_Load1"
     Maps(16)="DXHMP_AV_Load2"
     Maps(17)="DXHMP_AV_Load6"
     Maps(18)="DXHMP_AV_Load_7"
     MapSizes(0)="(4-8)"
     MapSizes(1)="(2-4)"
     MapSizes(2)="(4-6)"
     MapSizes(3)="(6-8)"
     MapSizes(4)="(2-4)"
     MapSizes(5)="(4-6)"
     MapSizes(6)="(4-6)"
     MapSizes(7)="(4-6)"
     MapSizes(8)="(6-8)"
     MapSizes(9)="(6-8)"
     MapSizes(10)="(4-6)"
     MapSizes(11)="(4-6)"
     MapSizes(12)="(4-6)"
     MapSizes(13)="(4-6)"
     MapSizes(14)="(4-6)"
     MapSizes(15)="(4-6)"
     MapSizes(16)="(4-6)"
     MapSizes(17)="(4-6)"
     MapSizes(18)="(4-6)"
     MapNum=0
     CycleNames(0)="Repeat map"
     CycleNames(1)="Random map"
     CycleNames(2)="Loop maps"
     NumTypes=3
}
