//=============================================================================
// MenuChoice_Class
// I found it! Here i should change portraits!
//=============================================================================

class MenuChoice_Class extends MenuUIChoiceEnum
	config;

var globalconfig string  ClassClasses[25]; //Actual classes of classes (sigh)
var localized String     ClassNames[25]; //Human readable class names.


//Portrait variables
var ButtonWindow btnPortrait;
var globalconfig Texture texPortraits[25];
var int PortraitIndex;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	PopulateClassChoices();
   CreatePortraitButton();

	Super.InitWindow();

   SetInitialClass();

   SetActionButtonWidth(153);

   btnAction.SetHelpText(HelpText);
   btnInfo.SetPos(0,195);
}

// ----------------------------------------------------------------------
// PopulateClassChoices()
// ----------------------------------------------------------------------

function PopulateClassChoices()
{
	local int typeIndex;

   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      enumText[typeIndex]=ClassNames[typeIndex];
   }
}

// ----------------------------------------------------------------------
// SetInitialClass()
// ----------------------------------------------------------------------

function SetInitialClass()
{
   local string TypeString;
   local int typeIndex;

   
   TypeString = player.GetDefaultURL("Class");
  
   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
}

// ----------------------------------------------------------------------
// SetValue()
// ----------------------------------------------------------------------

function SetValue(int newValue)
{
   Super.SetValue(newValue);
   UpdatePortrait();
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.UpdateURL("Class", GetModuleName(currentValue), true);
   player.SaveConfig();
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local string TypeString;
   local int typeIndex;
   
   TypeString = player.GetDefaultURL("Class");

   for (typeIndex = 0; typeIndex < arrayCount(ClassNames); typeIndex++)
   {
      if (TypeString==GetModuleName(typeIndex))
         SetValue(typeIndex);
   }
   UpdatePortrait();
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.UpdateURL("Class", GetModuleName(defaultValue), true);
   player.SaveConfig();
   LoadSetting();
}

// ----------------------------------------------------------------------
// GetModuleName()
// For command line parsing
// ----------------------------------------------------------------------

function string GetModuleName(int ClassIndex)
{
   return (ClassClasses[ClassIndex]);
}

// ----------------------------------------------------------------------
// CreatePortraitButton()
// ----------------------------------------------------------------------

function CreatePortraitButton()
{
	btnPortrait = ButtonWindow(NewChild(Class'ButtonWindow'));

        btnPortrait.SetSize(116, 163);
        btnPortrait.SetPos(19, 27);
        
	btnPortrait.SetBackgroundStyle(DSTY_Masked);
}

// ----------------------------------------------------------------------
// UpdatePortrait()
// ----------------------------------------------------------------------

function UpdatePortrait()
{
   btnPortrait.SetBackground(texPortraits[CurrentValue]);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     ClassClasses(0)="DeusEx.MPDenton"
     ClassClasses(1)="DeusEx.MPNSF"
     ClassClasses(2)="DeusEx.MPUnatco"
     ClassClasses(3)="DeusEx.MPMJ12"
     ClassClasses(4)="DeusEx.MPAlexJacobson"
     ClassClasses(5)="DeusEx.MPAnnaNavarre"
     ClassClasses(6)="DeusEx.MPCop"
     ClassClasses(7)="DeusEx.MPGordonQuick"
     ClassClasses(8)="DeusEx.MPHowardStrong"
     ClassClasses(9)="DeusEx.MPLebedev"
     ClassClasses(10)="DeusEx.MPJock"
     ClassClasses(11)="DeusEx.MPLumPath"
     ClassClasses(12)="DeusEx.MPDarkMaiden"
     ClassClasses(13)="DeusEx.MPMIB"
     ClassClasses(14)="DeusEx.MPPaulDenton"
     ClassClasses(15)="DeusEx.MPRiotCop"
     ClassClasses(16)="DeusEx.MPSailor"
     ClassClasses(17)="DeusEx.MPGuntherHermann"
     ClassClasses(18)="DeusEx.MPSmuggler"
     ClassClasses(19)="DeusEx.MPResearcher"
     ClassClasses(20)="DeusEx.MPTracerTong"
     ClassClasses(21)="DeusEx.MPWaltonSimons"
     ClassClasses(22)="DeusEx.MPWIB"
     ClassClasses(23)="DeusEx.MPSamCarter"
     ClassClasses(24)="DeusEx.MPMaggie"
     ClassNames(0)="JC Denton"
     ClassNames(1)="NSF Terrorist"
     ClassNames(2)="UNATCO Trooper"
     ClassNames(3)="Majestic-12 Agent"
     ClassNames(4)="Hacker"
     ClassNames(5)="Female Mech"
     ClassNames(6)="Cop"
     ClassNames(7)="Chinesse Gang Leader"
     ClassNames(8)="Psyhotic"
     ClassNames(9)="Russian Terrorist"
     ClassNames(10)="Pilot"
     ClassNames(11)="Chinesse Criminal"
     ClassNames(12)="Dark Maiden"
     ClassNames(13)="MIB"
     ClassNames(14)="Augmented Human"
     ClassNames(15)="Riot Cop"
     ClassNames(16)="Russian Sailor"
     ClassNames(17)="German Mech"
     ClassNames(18)="Smuggler"
     ClassNames(19)="Scientist"
     ClassNames(20)="Chinesse Scientist"
     ClassNames(21)="Augmented Human"
     ClassNames(22)="WIB"
     ClassNames(23)="Military Specialist"
     ClassNames(24)="Chinesse Girl"
     texPortraits(0)=Texture'DeusExUI.UserInterface.menuplayersetupjcdenton'
     texPortraits(1)=Texture'DeusExUI.UserInterface.menuplayersetupnsf'
     texPortraits(2)=Texture'DeusExUI.UserInterface.menuplayersetupunatco'
     texPortraits(3)=Texture'DeusExUI.UserInterface.menuplayersetupmj12'
     texPortraits(4)=Texture'DeusEx.AJacobson'
     texPortraits(5)=Texture'DeusEx.Anna'
     texPortraits(6)=Texture'DeusEx.Cop2'
     texPortraits(7)=Texture'DeusEx.GordonQuick'
     texPortraits(8)=Texture'DeusEx.Howard'
     texPortraits(9)=Texture'DeusEx.Lebedev'
     texPortraits(10)=Texture'DeusEx.Jock'
     texPortraits(11)=Texture'DeusEx.ChineseGang'
     texPortraits(12)=Texture'DeusEx.DarkMaiden'
     texPortraits(13)=Texture'DeusEx.MIB'
     texPortraits(14)=Texture'DeusEx.PaulDenton'
     texPortraits(15)=Texture'DeusEx.Cop1'
     texPortraits(16)=Texture'DeusEx.Ivan'
     texPortraits(17)=Texture'DeusEx.GHermann'
     texPortraits(18)=Texture'DeusEx.Smuggler'
     texPortraits(19)=Texture'DeusEx.Crazy'
     texPortraits(20)=Texture'DeusEx.TTong'
     texPortraits(21)=Texture'DeusEx.WSimons'
     texPortraits(22)=Texture'DeusEx.WIB'
     texPortraits(23)=Texture'DeusEx.SamCarter'
     texPortraits(24)=Texture'DeusEx.MChow'
     defaultInfoWidth=153
     defaultInfoPosX=170
     HelpText="Model for your character in non-team games."
     actionText="Non-Team Model"
}
