//=============================================================================
// MenuChoice_Cycle
//=============================================================================

class MenuChoice_Cycle extends MenuChoice_OnOff;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
   Super.InitWindow();

   SetActionButtonWidth(179);
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
	local String SettingString;
	local int enumIndex;
	local int SettingChoice;

	SettingString = player.ConsoleCommand("get " $ configSetting);
	SettingChoice = 0;

	for (enumIndex=0; enumIndex<arrayCount(FalseTrue); enumIndex++)
	{
		if (FalseTrue[enumIndex] == SettingString)
		{
			SettingChoice = enumIndex;
			break;
		}	
	}

	SetValue(SettingChoice);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
	player.ConsoleCommand("set " $ configSetting $ " " $ FalseTrue[GetValue()]);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     enumText(0)="Normal"
     enumText(1)="HardCore"
     defaultValue=1
     defaultInfoWidth=243
     defaultInfoPosX=203
     HelpText="Sets the game style between normal and HardCore"
     actionText="Game Style"
     configSetting="DeusExMPGame bHardCoreMode"
}
