//=============================================================================
// MenuChoice_SkillLevel
//=============================================================================

class MenuChoice_SkillLevel extends MenuUIChoiceEnum;

var int SkillLevel; 
var localized String LevelNames[3]; 
var BotInfo myInfo;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
   Super.InitWindow();

   PopulateSkillLevels();

   SetInitialSkillLevel();

   SetActionButtonWidth(179);
}

// ----------------------------------------------------------------------
// PopulateSkillLevels()
// ----------------------------------------------------------------------

function PopulateSkillLevels()
{
   local int typeIndex;

   myInfo = player.Spawn(class'BotInfo');

   if (myInfo == None)
   {
      return;
   }

   for (typeIndex = 0; typeIndex < 8; typeIndex++)
   {
      enumText[typeIndex] = myInfo.Skills[typeIndex];
   }

   myInfo.Destroy();	
}

// ----------------------------------------------------------------------
// SetInitialSkillLevel()
// ----------------------------------------------------------------------

function SetInitialSkillLevel()
{
   local int CurrentType;

   CurrentType = int(player.ConsoleCommand("get" @ configsetting)); 

   SetValue(CurrentType);
}

// ----------------------------------------------------------------------
// SaveSetting()
// ----------------------------------------------------------------------

function SaveSetting()
{
   player.ConsoleCommand("set" @ configsetting @ currentvalue);
}

// ----------------------------------------------------------------------
// LoadSetting()
// ----------------------------------------------------------------------

function LoadSetting()
{
   local int CurrentType;
   
   CurrentType = int(player.ConsoleCommand("get" @ configsetting)); 

   SetValue(CurrentType);
}

// ----------------------------------------------------------------------
// ResetToDefault
// ----------------------------------------------------------------------

function ResetToDefault()
{   
   player.ConsoleCommand("set " $ configSetting $ " " $ defaultvalue);
   LoadSetting();
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     defaultValue=5
     defaultInfoWidth=243
     defaultInfoPosX=203
     HelpText="Select difficulty level based on bot skills"
     actionText="Bot Skills"
     configSetting="BotInfo Difficulty"
}
