//=============================================================================
// Block, Deployed.
//=============================================================================
class BlockDeployed extends Containers;

//Basic Block Stuff
var string BlockName;
var float DrawMult, BlockSize;

//Neighboring Properties
var bool bCanBranch, bHasGravity;
var BlockDeployed CurNeighbors[6];
var int ChargeDirection, DependantDirection;
var float FallDistance;

//Redstone Variables
var RedstoneNetwork RedstoneNetwork;
var bool bHasCharge, bEmitsCharge, bMadeNetwork;
var int ChargeStrength;
var BlockDeployed ChargeSource;

var BlockFace Faces[6];

function int OtherEnd(int i)
{
 if (i == 0) return 1;
 if (i == 1) return 0;

 if (i == 2) return 3;
 if (i == 3) return 2;

 if (i == 4) return 5;
 if (i == 5) return 4;
}

function int RoundUnits(int i)
{
 local string S;
 local int Length, Singles, Offset, bRoundUp;
 local bool bNegative;
 
 bNegative = (i < 0);
 
 Singles = ABS(i);

 if (Singles > CollisionRadius * 2)
 {
  do
  {
   Singles -= CollisionRadius * 2;
  }
  until (Singles < CollisionRadius)
 }
 
 if (float(Singles) >= CollisionRadius * 2 / 2) bRoundUp = 1; 
 
 if (!bNegative) i = i - Singles + (CollisionRadius * 2 * bRoundUp);
 if (bNegative) i = i + Singles - (CollisionRadius * 2 * bRoundUp);
 
 return i;
}

function ApplyBlockName(String NewName)
{
 BlockName = NewName;
 ItemName = NewName;
}

function CreateFaces()
{
 local int i;
 local BlockFace F;
 
 for(i=0; i<6; i++)
 {  
  Faces[i] = Spawn(class'BlockFace',,,Location);
  Faces[i].Parent = Self;
  Faces[i].SetSide(i);
 }
}

function ApplyBlockSize(float NewSize)
{
 BlockSize = NewSize;
 SetCollisionSize(NewSize, NewSize);
 
 DrawScale = NewSize / 5 * DrawMult;
 
 CreateFaces();
 
 AnalyzeNeighbors();
 if (bEmitsCharge && !bMadeNetwork) SetupRedstoneNetwork();
 
 SetTimer(0.1, True);
}

function SetupRedstoneNetwork()
{
 RedstoneNetwork = Spawn(class'RedstoneNetwork',,,Location + vect(0,0,1));
 
 if (RedstoneNetwork != None)
 {
  bMadeNetwork = True;
  RedstoneNetwork.Source = Self;
 }
}

function Destroyed()
{
 Faces[0].Destroy();
 Faces[1].Destroy();
 Faces[2].Destroy();
 Faces[3].Destroy();
 Faces[4].Destroy();
 Faces[5].Destroy();
 
 Super.Destroyed();
}

function Frob(Actor Frobber, Inventory frobWith)
{
 Pawn(Frobber).ClientMessage("Obtained 1 Unit Of "$BlockName$"!");
  
 Destroy();
 
 UpdateNeighbors();
}


function int GetSideNum(Vector Norm)
{
 local float XVal, YVal, ZVal;
 
 ZVal = ABS(Norm.Z);
 YVal = ABS(Norm.Y);
 XVal = ABS(Norm.X);
 
 if (XVal >= YVal && XVal >= ZVal)
 {
  if (Norm.X >= 0) return 3;
  if (Norm.X < 0) return 2;
 }
 if (YVal > XVal && YVal >= ZVal)
 {
  if (Norm.Y >= 0) return 5;
  if (Norm.Y < 0) return 4;
 }
 if (ZVal > XVal && ZVal > YVal)
 {
  if (Norm.Z >= 0) return 1;
  if (Norm.Z < 0) return 0;
 }
 
 return -1;
}

function Vector GetNormal(int Side)
{
 if (Side == 0) return vect(0,0,2) * CollisionHeight;
 if (Side == 1) return vect(0,0,2) * CollisionHeight * -1;
 if (Side == 2) return vect(2,0,0) * CollisionRadius;
 if (Side == 3) return vect(2,0,0) * CollisionRadius * -1;
 if (Side == 4) return vect(0,2,0) * CollisionRadius;
 if (Side == 5) return vect(0,2,0) * CollisionRadius * -1;
 
 return vect(0,0,0);
}

function int NumberOfNeighbors()
{
 local int i, Count;
 
 for(i=0; i<6; i++)
 {
  if (CurNeighbors[i] != None)
  {
   Count++;
  }
 }
 
 return Count;
}

function Actor PollLocation(Vector V)
{
 local Actor A;
 
 
 forEach RadiusActors(class'Actor', A, 256, V)
 {
  if (A != None && A.IsA('BlockDeployed') && A != Self)
  {
   if (A.Location.X == V.X && A.Location.Y == V.Y && A.Location.Z == V.Z)
   {
    return A;
   }
  }
 }
 
 return None;
}



function AnalyzeNeighbors()
{
 local BlockDeployed Temp;
 
 //BroadcastMessage("Analyzing Neighbors!");
 
 //Upwards
 CurNeighbors[0] = BlockDeployed(PollLocation(Location + vect(0,0,2) * CollisionHeight));

 //Downwards
 CurNeighbors[1] = BlockDeployed(PollLocation(Location - vect(0,0,2) * CollisionHeight));

 //Xwards
 CurNeighbors[2] = BlockDeployed(PollLocation(Location + vect(2,0,0) * CollisionRadius));

 //Anti-Xwards
 CurNeighbors[3] = BlockDeployed(PollLocation(Location - vect(2,0,0) * CollisionRadius));

 //Ywards
 CurNeighbors[4] = BlockDeployed(PollLocation(Location + vect(0,2,0) * CollisionRadius));

 //Anti-Ywards
 CurNeighbors[5] = BlockDeployed(PollLocation(Location - vect(0,2,0) * CollisionRadius));
 
 //BroadcastMessage(CurNeighbors[0]$CurNeighbors[1]$CurNeighbors[2]$CurNeighbors[3]$CurNeighbors[4]$CurNeighbors[5]);
}


function UpdateNeighbors()
{
 local int i;
 
 for(i=0; i<6; i++)
 {
  if (CurNeighbors[i] != None)
  {
   CurNeighbors[i].UpdateBlock();
  }
 }
}

function UpdateBlock()
{
 local bool B;
 local vector TempLoc;
 
 AnalyzeNeighbors();
 
 if (NumberOfNeighbors() > 5) Mesh = None;
 else Mesh = Default.Mesh;
 
 if (CurNeighbors[1] == None && bHasGravity && FastTrace(Location - (vect(0,0,3) * CollisionHeight) + vect(0,0,1), Location) && FallDistance <= 0)
 {
  FallDistance = CollisionHeight * 2;
  b = True;
 }
 if (FallDistance > 0 && bHasGravity)
 {
  SetLocation(Location - (vect(0,0,1) * FClamp(FallDistance,0,CollisionHeight / 1.667)));
  FallDistance -= FClamp(FallDistance,0,CollisionHeight / 1.667);
 }
 
 if (FallDistance <= 0 && !IsA('TNTBlockDeployed') && bHasGravity)
 {  
  TempLoc = Location;
  TempLoc.X = RoundUnits(TempLoc.X);
  TempLoc.Y = RoundUnits(TempLoc.Y);
  TempLoc.Z = RoundUnits(TempLoc.Z);
  
  SetLocation(TempLoc);

  if (PollLocation(TempLoc) != None) Destroy();
 }
}

function Timer()
{
 if (!IsA('TNTBlockDeployed') || !TNTBlockDeployed(Self).bLit) ScaleGlow = 1.000000;
 UpdateBlock();
}

defaultproperties
{
     bInvincible=False

     bFlammable=False
     ItemName="EXSAMPLE"
     bBlockSight=True
     Mesh=None
     CollisionRadius=5.000000
     CollisionHeight=5.000000
     DrawScale=0.155000
     Mass=18.000000
     Buoyancy=18.000000
     bPushable=False
     Physics=PHYS_Projectile
     
     DrawMult=0.312500
     Style=STY_Normal
     bNoSmooth=True
     bUnlit=True
     bCanBranch=True
     ChargeDirection=-1
     FragType=None
}
