//=============================================================================
// BowenEMPGrenade.
//=============================================================================
class BowenEMPGrenade extends BowenGrenade;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

function Fire(float Value)
{
	// if facing a wall, affix the EMPGrenade to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}
/*
function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local Projectile proj;

	proj = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);

	if (proj != None)
		proj.PlayAnim('Open');
}*/

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 4);
}

//---END-CLASS---

defaultproperties
{
    LowAmmoWaterMark=2
    GoverningSkill=Class'DeusEx.SkillDemolition'
    EnemyEffective=2
    Concealability=1
    ShotTime=0.30
    reloadTime=0.10
    HitDamage=0
    maxRange=4800
    AccurateRange=2400
    BaseAccuracy=1.00
    bPenetrating=False
    StunDuration=60.00
    bHasMuzzleFlash=False
    bHandToHand=True
    bUseAsDrawnWeapon=False
    AITimeLimit=3.50
    AIFireDelay=5.00
    bNeedToSetMPPickupAmmo=False
    mpReloadTime=0.10
    mpBaseAccuracy=1.00
    mpAccurateRange=2400
    mpMaxRange=2400
    AmmoName=Class'DeusEx.AmmoEMPGrenade'
    ReloadCount=1
    PickupAmmoCount=1
    FireOffset=(X=0.00,Y=10.00,Z=20.00),
    ProjectileClass=Class'DeusEx.EMPGrenade'
    shakemag=50.00
    SelectSound=Sound'DeusExSounds.Weapons.EMPGrenadeSelect'
    InventoryGroup=22
    ItemName="Electromagnetic Pulse (EMP) Grenade"
    ItemArticle="an"
    PlayerViewOffset=(X=24.00,Y=-15.00,Z=-19.00),
    PlayerViewMesh=LodMesh'DeusExItems.EMPGrenade'
    PickupViewMesh=LodMesh'DeusExItems.EMPGrenadePickup'
    ThirdPersonMesh=LodMesh'DeusExItems.EMPGrenade3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconEMPGrenade'
    largeIcon=Texture'DeusExUI.Icons.LargeIconEMPGrenade'
    largeIconWidth=31
    largeIconHeight=49
    Description="The EMP grenade creates a localized pulse that will temporarily disable all electronics within its area of effect, including cameras and security grids.|n|n<UNATCO OPS FILE NOTE JR134-VIOLET> While nanotech augmentations are largely unaffected by EMP, experiments have shown that it WILL cause the spontaneous dissipation of stored bioelectric energy. -- Jaime Reyes <END NOTE>"
    beltDescription="EMP GREN"
    Mesh=LodMesh'DeusExItems.EMPGrenadePickup'
    CollisionRadius=3.00
    CollisionHeight=2.43
    Mass=5.00
    Buoyancy=2.00
}
