//=============================================================================
// BowenFireball.
//=============================================================================
class BowenFireball extends DeusExProjectile;

var() float mpDamage;
var ParticleGenerator fireGen;
var bool bCanHitOwner;

#exec OBJ LOAD FILE=Effects

simulated function Tick(float deltaTime)
{
	local float value;
	local float sizeMult;

	// don't Super.Tick() becuase we don't want gravity to affect the stream
	time += deltaTime/3;

	value = 1.0+time;
	if (MinDrawScale > 0)
		sizeMult = MaxDrawScale/MinDrawScale;
	else
		sizeMult = 1;

	DrawScale = (-sizeMult/(value*value) + (sizeMult+1))*MinDrawScale;
	ScaleGlow = Default.ScaleGlow/(value*value*value);
	if(fireGen != None)
	{
		fireGen.ParticleDrawScale=DrawScale;
		fireGen.scaleGlow=scaleGlow;
	}
	
	if(LifeSpan < 0.3 && fireGen != None)
		fireGen.delayedDestroy();
}

function ZoneChange(ZoneInfo NewZone)
{
	Super.ZoneChange(NewZone);

	// If the fireball enters water, extingish it
	if (NewZone.bWaterZone)
		Destroy();
}

simulated function SpawnFireEffects()
{
	fireGen = Spawn(class'ParticleGenerator', Self);
	if (fireGen != None)
	{
		fireGen.particleTexture = FireTexture'Effects.Fire.flame_b';
		fireGen.particleDrawScale = DrawScale;
		fireGen.checkTime = 0.06;
		fireGen.riseRate = 8.0;
		fireGen.ejectSpeed = 500.0;
		fireGen.particleLifeSpan = 0.5;
		fireGen.bFade=True;
		fireGen.bTranslucent=True;
		fireGen.bRandomEject = False;
		fireGen.SetBase(Self);
      fireGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (fireGen != None)
		fireGen.DelayedDestroy();

	Super.Destroyed();
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
		Damage = mpDamage;
		
	if ( Level.NetMode != NM_DedicatedServer )
		SpawnFireEffects();
}


auto simulated state Flying
{
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		SpawnEffects(Location, HitNormal, Wall);
		Velocity -= 2 * (Velocity dot HitNormal) * HitNormal; // oh dear bob bouncy fireballs
		SetRotation(rotator(velocity));
		if(fireGen != None)
			fireGen.setRotation(rotation);
		LifeSpan = LifeSpan / 5;
		bCanHitOwner=True;
		setCollisionSize(collisionRadius*2, collisionHeight*2); // get bigger
		MaxDrawScale *= 2;
		Super.HitWall(HitNormal, Wall);
	}
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (bStuck)
			return;

		if ((DeusExProjectile(Other) == None) && ( bCanHitOwner || (Other != instigator && Other != Owner)))
		{
			damagee = Other;
			Explode(HitLocation, Normal(HitLocation-damagee.Location));

         // DEUS_EX AMSD Spawn blood server side only
         if (Role == ROLE_Authority)
			{
            if (damagee.IsA('Pawn') && !damagee.IsA('Robot') && bBlood)
               SpawnBlood(HitLocation, Normal(HitLocation-damagee.Location));
			}
		}
	}
	simulated function Explode(vector HitLocation, vector HitNormal)
	{
		// Server side only
		if ( Role == ROLE_Authority )
		{
			if (damagee != None)
			{
				if ( Level.NetMode != NM_Standalone )
				{
					if ( damagee.IsA('DeusExPlayer') )
						DeusExPlayer(damagee).myProjKiller = Self;
				}
				damagee.TakeDamage(Damage, Pawn(Owner), HitLocation, MomentumTransfer*Normal(Velocity), damageType);
				HurtRadius (1, BlastRadius, 'Flamed', 0, Location, True); // and a bit of AoE damage
			}
		}
	}
}

//---END-CLASS---

defaultproperties
{
    mpDamage=5.00
    blastRadius=100.00
    DamageType=Flamed
    AccurateRange=3200
    maxRange=3200
    bIgnoresNanoDefense=True
    ItemName="Fireball"
    ItemArticle="a"
    speed=1500.00
    MaxSpeed=1500.00
    Damage=5.00
    MomentumTransfer=5000
    ExplosionDecal=Class'DeusEx.BurnMark'
    LifeSpan=1.50
    DrawType=1
    Style=3
    Texture=FireTexture'Effects.Fire.flame_b'
    DrawScale=0.10
    bUnlit=True
    CollisionRadius=15.00
    CollisionHeight=15.00
    LightType=1
    LightEffect=13
    LightBrightness=200
    LightHue=16
    LightSaturation=32
    LightRadius=2
    bBounce=True
}
