//=============================================================================
// BowenFlare.
//=============================================================================
class BowenFlare extends DeusExProjectile;

#exec OBJ LOAD FILE=Effects

var ParticleGenerator smokeGen;
var (Bowen) float GravMult;
var actor WhackActor;

function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnSmokeEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.02;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
      smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{

	if (smokeGen != None)
		smokeGen.DelayedDestroy();
	Super.Destroyed();

}

/*
simulated function DrawEffects(vector HitLocation)
{
   local ParticleGenerator FlareGen;

	// Spawn the pretty effects!
	FlareGen = Spawn(class'ParticleGenerator',,,HitLocation + vect(0,0,3));
	if (FlareGen != None)
	{
		FlareGen.particleTexture = Texture'Effects.Corona.Corona_E';
		FlareGen.particleDrawScale = 0.3;
		FlareGen.checkTime = 0.02;
		FlareGen.riseRate = 128.0;
		FlareGen.ejectSpeed = 0.0;
		FlareGen.particleLifeSpan = 0.5;
		FlareGen.bRandomEject = True;
      		FlareGen.RemoteRole = ROLE_None;
	}
	Super.DrawEffects(HitLocation);
}*/


simulated function tick (float deltatime)
{
	local float dist;

	Super.tick(deltatime);

	dist = Abs(VSize(initLoc - Location));

	if (dist > AccurateRange)		// start descent due to "gravity"
		Acceleration = GravMult*Region.Zone.ZoneGravity;		
}

auto state flying
{
	function ProcessTouch(Actor Other, Vector HitLocation)
	{
		if(Other != Owner && Pawn(Other) != None)
		{
			WhackActor = Other;
			//log("BowenFlare - Aquired WhackActor");
		}
		Super.ProcessTouch(Other, HitLocation);
	}

	function Explode (Vector HitLocation, vector HitNormal)
	{	
	   local FlareDamage fd;

		//if(Level.NetMode != Nm_client)
		//{
			fd = Spawn (class'FlareDamage',Owner,,HitLocation + HitNormal*10, rotator(HitNormal));
			if (fd != None && WhackActor != None)
			{
				if(Level.NetMode == NM_Standalone)
					fd.WhackActor = WhackActor;
				fd.SetBase(WhackActor);
				fd.SetRotation(rotator(vect(0,0,1)));
			}
		//}
		Super.Explode(HitLocation, HitNormal);
	}
}

function ProcessTouch(Actor Other, Vector HitLocation)
{
	if(Other != Owner && Other != None)
	{
		WhackActor = Other;
		//log("BowenFlare - Aquired WhackActor");
	}
	Super.ProcessTouch(Other, HitLocation);
}

defaultproperties
{
    GravMult=0.25
    bExplodes=True
    bBlood=True
    bDebris=True
    blastRadius=100.00
    DamageType=Flamed
    AccurateRange=0
    maxRange=5000
    ItemName="flare gun"
    ItemArticle="a"
    speed=1750.00
    MaxSpeed=5000.00
    Damage=25.00
    SpawnSound=Sound'DeusExSounds.Weapons.GEPGunFire'
    ExplosionDecal=Class'DeusEx.ScorchMark'
    DrawType=1
    Style=3
    Texture=Texture'DeusExDeco.Skins.AlarmLightTex6'
    Mesh=LodMesh'DeusExItems.HECannister20mm'
    bAlwaysRelevant=True
    LightType=1
    LightBrightness=128
    LightSaturation=255
    LightRadius=16
}
