//=============================================================================
// BowenGasGrenade.
//=============================================================================
class BowenGasGrenade extends BowenGrenade;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

function Fire(float Value)
{
	// if facing a wall, affix the GasGrenade to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 5);
}

//---END-CLASS---

defaultproperties
{
    LowAmmoWaterMark=2
    GoverningSkill=Class'DeusEx.SkillDemolition'
    EnemyEffective=1
    EnviroEffective=1
    Concealability=3
    ShotTime=0.30
    reloadTime=0.10
    HitDamage=0
    maxRange=4800
    AccurateRange=2400
    BaseAccuracy=1.00
    bPenetrating=False
    StunDuration=60.00
    bHasMuzzleFlash=False
    bHandToHand=True
    bUseAsDrawnWeapon=False
    AITimeLimit=4.00
    AIFireDelay=20.00
    bNeedToSetMPPickupAmmo=False
    mpReloadTime=0.10
    mpHitDamage=2
    mpBaseAccuracy=1.00
    mpAccurateRange=2400
    mpMaxRange=2400
    AmmoName=Class'DeusEx.AmmoGasGrenade'
    ReloadCount=1
    PickupAmmoCount=1
    FireOffset=(X=0.00,Y=10.00,Z=20.00),
    ProjectileClass=Class'DeusEx.GasGrenade'
    shakemag=50.00
    SelectSound=Sound'DeusExSounds.Weapons.GasGrenadeSelect'
    InventoryGroup=21
    ItemName="Gas Grenade"
    PlayerViewOffset=(X=30.00,Y=-13.00,Z=-19.00),
    PlayerViewMesh=LodMesh'DeusExItems.GasGrenade'
    PickupViewMesh=LodMesh'DeusExItems.GasGrenadePickup'
    ThirdPersonMesh=LodMesh'DeusExItems.GasGrenade3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconGasGrenade'
    largeIcon=Texture'DeusExUI.Icons.LargeIconGasGrenade'
    largeIconWidth=23
    largeIconHeight=46
    Description="Upon detonation, the gas grenade releases a large amount of CS (a military-grade 'tear gas' agent) over its area of effect. CS will cause irritation to all exposed mucous membranes leading to temporary blindness and uncontrolled coughing. Like a LAM, gas grenades can be attached to any surface."
    beltDescription="GAS GREN"
    Mesh=LodMesh'DeusExItems.GasGrenadePickup'
    CollisionRadius=2.30
    CollisionHeight=3.30
    Mass=5.00
    Buoyancy=2.00
}
