//=============================================================================
// BowenGlowSprite. 	(c) 2003 JimBowen
//=============================================================================
class BowenGlowSprite expands Effects;

var bool bFade, bRPSprite;
var float CycleDepth;
var (Bowen) float MinAmplitude;
var (Bowen) float Frequency;

simulated function tick (float deltatime)
{
	local float CycleDepth;

		CycleDepth = sin(Level.TimeSeconds*(1/(2*pi))*Frequency);
		if(CycleDepth < 0)
			CycleDepth = -1*CycleDepth;

		if (!bRPSprite && Owner.IsA('RocketPod'))	
			bRPSprite = True;

		if (bRPSprite && Owner == None)	//owning pod destroyed
			Destroy();

		DrawScale = Default.DrawScale*MinAmplitude + (Default.DrawScale - MinAmplitude*Default.DrawScale) * CycleDepth;
		LightBrightness = Default.LightBrightness*MinAmplitude + (Default.LightBrightness - MinAmplitude*Default.LightBrightness) * CycleDepth;
		//DrawScale = Default.DrawScale*MinAmplitude + (Default.DrawScale - MinAmplitude*Default.DrawScale) * CycleDepth;
}

//---END-CLASS---

defaultproperties
{
    MinAmplitude=0.20
    Frequency=4.00
    DrawType=1
    Style=3
    Texture=Texture'DeusExDeco.Skins.AlarmLightTex2'
    LightBrightness=64
}
