//=============================================================================
// BowenLAM.
//=============================================================================
class BowenLAM extends BowenGrenade;

var localized String shortName;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

function Fire(float Value)
{
	// if facing a wall, affix the LAM to the wall
	if (Pawn(Owner) != None)
	{
		if (bNearWall)
		{
			bReadyToFire = False;
			GotoState('NormalFire');
			bPointing = True;
			PlayAnim('Place',, 0.1);
			return;
		}
	}

	// otherwise, throw as usual
	Super.Fire(Value);
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 6);
}

//---END-CLASS---

defaultproperties
{
    ShortName="LAM"
    LowAmmoWaterMark=2
    GoverningSkill=Class'DeusEx.SkillDemolition'
    EnviroEffective=4
    Concealability=3
    ShotTime=0.30
    reloadTime=0.10
    HitDamage=50
    maxRange=4800
    AccurateRange=2400
    BaseAccuracy=1.00
    bHasMuzzleFlash=False
    bHandToHand=True
    bUseAsDrawnWeapon=False
    AITimeLimit=3.50
    AIFireDelay=5.00
    bNeedToSetMPPickupAmmo=False
    mpReloadTime=0.10
    mpHitDamage=50
    mpBaseAccuracy=1.00
    mpAccurateRange=2400
    mpMaxRange=2400
    AmmoName=Class'DeusEx.AmmoLAM'
    ReloadCount=1
    PickupAmmoCount=1
    FireOffset=(X=0.00,Y=10.00,Z=20.00),
    ProjectileClass=Class'DeusEx.LAM'
    shakemag=50.00
    SelectSound=Sound'DeusExSounds.Weapons.LAMSelect'
    InventoryGroup=20
    ItemName="Lightweight Attack Munitions (LAM)"
    PlayerViewOffset=(X=24.00,Y=-15.00,Z=-17.00),
    PlayerViewMesh=LodMesh'DeusExItems.LAM'
    PickupViewMesh=LodMesh'DeusExItems.LAMPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.LAM3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconLAM'
    largeIcon=Texture'DeusExUI.Icons.LargeIconLAM'
    largeIconWidth=35
    largeIconHeight=45
    Description="A multi-functional explosive with electronic priming system that can either be thrown or attached to any surface with its polyhesive backing and used as a proximity mine.|n|n<UNATCO OPS FILE NOTE SC093-BLUE> Disarming a proximity device should only be attempted with the proper demolitions training. Trust me on this. -- Sam Carter <END NOTE>"
    beltDescription="LAM"
    Mesh=LodMesh'DeusExItems.LAMPickup'
    CollisionRadius=3.80
    CollisionHeight=3.50
    Mass=5.00
    Buoyancy=2.00
}
