//=============================================================================
// BowenNade. 	(c) 2003 JimBowen
//=============================================================================
class BowenNade expands DeusExprojectile;

var () float			Elasticity; // multiply our velocity by this each bounce
var () float 			ExplosionTime,EffectsTime, particleModifier;	// speed to execute explosion effects, multiplier for particle effect radius
var () Texture			SphereTexture;	//texture for blast sphere
var () float			impactTolerance;
var () Texture			ParticleTexture; // texture for particle sprites
var () class <Actor> ParticleClass; // class for particle effects
var () class <AnimatedSprite> ExplosionClass;
var () int 				numParticles; // number of particle sprites
var () bool 			bSphere, bLight; // do we want a fading light, and a blast sphere
var () int				maxBounces;

var ParticleGenerator smokeGen;
var bool bDetonated, bHitOwner;
var int bounces;

replication
{
	reliable if (Role == ROLE_Authority)
		Detonate;
}

auto simulated state Flying
{
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		local Rotator rot;
		local float   volume;
		
		if(!bBounce)
		{
			Detonate();
			return;
		}

		Velocity = Elasticity*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		speed = VSize(Velocity);	
		RotationRate = RotRand(True);
		bounces++;
		bHitOwner=True;
// 		DeusExPlayer(Owner).ClientMessage("Impact:" $ (velocity dot hitNormal) * (speed / MaxSpeed) $ ", speed:" $ speed);
		if ( ((speed < 50) && (HitNormal.Z > 0.7)) || bounces > maxBounces || (velocity dot hitNormal) * (speed / MaxSpeed)  > impactTolerance)
		{
			volume = 0.5+FRand()*0.5;
			PlaySound(MiscSound, SLOT_None, volume,, 512, 0.85+FRand()*0.3);
			Detonate();
		}
		else If (speed > 50) 
		{
			PlaySound(MiscSound, SLOT_None, 0.5+FRand()*0.5,, 512, 0.85+FRand()*0.3);
		}
	}
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		Super.ProcessTouch(Other, HitLocation);
		if(Other == Owner && bHitOwner) // hack
			detonate();
	}
	simulated function tick (float deltatime)
	{
		super.tick(deltatime);
		if (lifeSpan < 1 && !bDetonated)
			detonate();
	}
}

function Detonate()
{
	if(bDetonated)
		return;
	bDetonated = True;
	super.HitWall(vect(0,0,1), Level);
}


function PostBeginPlay()
{
	Super.PostBeginPlay();

   if (Level.NetMode == NM_DedicatedServer)
      return;
   
   SpawnSmokeEffects();
}

simulated function PostNetBeginPlay()
{
   Super.PostNetBeginPlay();
   
   if (Role != ROLE_Authority)
      SpawnSmokeEffects();
}

simulated function SpawnSmokeEffects()
{
	smokeGen = Spawn(class'ParticleGenerator', Self);
	if (smokeGen != None)
	{
		smokeGen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		smokeGen.particleDrawScale = 0.3;
		smokeGen.checkTime = 0.03;
		smokeGen.riseRate = 8.0;
		smokeGen.ejectSpeed = 0.0;
		smokeGen.particleLifeSpan = 2.0;
		smokeGen.bRandomEject = True;
		smokeGen.SetBase(Self);
      smokeGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (smokeGen != None)
		smokeGen.DelayedDestroy();

	Super.Destroyed();
}


simulated function DrawExplosionEffects(vector HitLocation, vector HitNormal)
{
	local ShockRing ring;
   local SphereEffect sphere;
	local ExplosionLight light;
   local AnimatedSprite expeffect;
   local RadLight RadLight;
   local int i;
   local float ParticleLifespan, ParticleSpeed;
   local vector fireDirection;
   local Actor Particle;

	// draw a pretty explosion
	light = Spawn(class'ExplosionLight',,, HitLocation);
   if (light != None)
      light.RemoteRole = ROLE_None;
   if(bLight)
		RadLight = Spawn(class'RadLight',,, (HitLocation + (HitNormal*50)));
	if (RadLight != None)
	{
		RadLight.RemoteRole = ROLE_None;
		RadLight.LightType = LT_Steady;
		RadLight.volumeFog=0;
		RadLight.volumeRadius=0;
		RadLight.volumeBrightness=0;
		RadLight.bHurtRadius = false;
		RadLight.LifeSpan=EffectsTime;
	}

	expeffect = Spawn(ExplosionClass,,, HitLocation);
	light.size = 10;

	if (expeffect != None)
		expeffect.RemoteRole = ROLE_None;
	
	if(bSphere)
	{
		sphere = Spawn(class'BlastSphere',,, HitLocation, rot(16384,0,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.skin = SphereTexture;
			sphere.size = blastRadius / 3.0;
			sphere.lifeSpan=ExplosionTime;
		}
		sphere = Spawn(class'BlastSphere',,, HitLocation, rot(0,0,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.skin = SphereTexture;
			sphere.size = blastRadius / 3.0;
			sphere.lifeSpan=ExplosionTime;
		}
		sphere = Spawn(class'BlastSphere',,, HitLocation, rot(0,16384,0));
		if (sphere != None)
		{
			sphere.RemoteRole = ROLE_None;
			sphere.skin = SphereTexture;
			sphere.size = blastRadius / 3.0;
			sphere.lifeSpan=ExplosionTime;
		}
	}
	
	// now for some cool effects
	for (i=0; i<NumParticles; i++)
	{
		fireDirection = normal(3*vrand()+HitNormal);
		ParticleLifespan = ((1 + ExplosionTime)-FRand())/2.0;
		ParticleSpeed = BlastRadius*ParticleModifier / ParticleLifespan;
		Particle = Spawn(ParticleClass,,,Location,rotator(fireDirection));
		Particle.Velocity = ParticleSpeed * fireDirection;
		Particle.LifeSpan = ParticleLifeSpan;
		Particle.Texture = ParticleTexture;
		Particle.setPhysics(PHYS_Projectile);
	}
}



defaultproperties
{
    elasticity=0.60
    ExplosionTime=0.50
    EffectsTime=8.00
    particleModifier=1.50
    SphereTexture=FireTexture'Effects.liquid.Virus_SFX'
    impactTolerance=175.00
    particleTexture=Texture'BowenData.Effects.HotGlow'
    ParticleClass=Class'PlasmaSpark'
    ExplosionClass=Class'DeusEx.ExplosionLarge'
    numParticles=15
    bSphere=True
    bLight=True
    MaxBounces=5
    bExplodes=True
    blastRadius=500.00
    DamageType=exploded
    AccurateRange=0
    ItemName="Grenade Launcher"
    speed=2000.00
    MaxSpeed=5000.00
    Damage=300.00
    MomentumTransfer=50000
    ImpactSound=Sound'DeusExSounds.Weapons.PlasmaRifleHit'
    MiscSound=Sound'DeusExSounds.Weapons.CrowbarHitHard'
    LifeSpan=10.00
    Texture=FireTexture'Effects.Electricity.Nano_SFX_A'
    Mesh=LodMesh'BowenData.JBVortexGrenade'
    DrawScale=0.20
    bAlwaysRelevant=True
    SoundRadius=16
    SoundVolume=224
    AmbientSound=Sound'DeusExSounds.Weapons.LAWApproach'
    CollisionRadius=3.00
    CollisionHeight=3.00
    bBounce=True
    Mass=5.00
    Buoyancy=2.00
}
