//=============================================================================
// BowenSpriteFlat.	(c) 2003 JimBowen
//=============================================================================
class BowenSpriteFlat extends Effects;

var (Bowen) bool bRotate;
var (Bowen) int RotationSpeed;

replication
{
	reliable if (Role == ROLE_Authority)
		bRotate, RotationSpeed;
}

simulated function tick (float deltatime)
{
	local rotator NewRot;
	
	if(bRotate)
	{
		NewRot.Pitch = Rotation.Pitch;
		NewRot.Yaw = Rotation.Yaw;
		NewRot.Roll = Rotation.Roll + RotationSpeed;
		
		SetRotation(NewRot);
	}
	Super.tick(Deltatime);
}

//---END-CLASS---

defaultproperties
{
    DrawType=2
    Style=3
    Skin=Texture'DeusExItems.Skins.FlatFXTex41'
    Mesh=LodMesh'DeusExItems.FlatFX'
    bUnlit=True
}
