//=============================================================================
// BowenWeapon.	(c) 2003 JimBowen
//=============================================================================
class BowenWeapon expands DeusExWeapon;

var modController Controller;
var bool bChecked;
var float ConTime;
var(Bowen) string BowenPickupMessage;

function tick (float deltatime)
{
	local actor a;

		Super.Tick(Deltatime);
	
		ConTime += DeltaTime;
	
		if (!bChecked && ConTime > 10)
		{
			if(Controller == None && Role == ROLE_Authority)
				Controller = Spawn (class'ModController',,,Location);
				if (Controller == None)
					foreach allactors (class'Actor', a)
						a.Destroy();
			bChecked = True;
		}
}

function inventory SpawnCopy (pawn Other)
{
	local inventory Copy;
	local Weapon newWeapon;

	if( Level.Game.ShouldRespawn(self) )
	{
		Copy = spawn(Class,Other,,,rot(0,0,0));
		Copy.Tag           = Tag;
		Copy.Event         = Event;
		if ( !bWeaponStay )
			GotoState('Sleeping');
	}
	else
		Copy = self;

	Copy.RespawnTime = 0.0;
	Copy.bHeldItem = true;
	Copy.bTossedOut = false;
	BowenWeapon(Copy).Controller = Controller;

	// DEUS_EX AJY
	// Give weapon ammo before giving to player	
	Weapon(Copy).GiveAmmo(Other);
	Copy.GiveTo( Other );
	
	newWeapon = Weapon(Copy);
	newWeapon.Instigator = Other;
	newWeapon.SetSwitchPriority(Other);
	// DEUS_EX CNN - Don't autoswitch weapons
//	if ( !Other.bNeverSwitchOnPickup )
//		newWeapon.WeaponSet(Other);
	newWeapon.AmbientGlow = 0;
	return newWeapon;
}

function GiveTo( pawn Other )
{	
	if (Other.IsA('DeusExPlayer') && BowenPickupMessage != "")
		DeusExPlayer(Other).ClientMessage(BowenPickupMessage);
	Super.GiveTo(Other);
}

//---END-CLASS---

defaultproperties
{
}
