//=============================================================================
// ClusterBomb.
//=============================================================================
class ClusterBomb extends BowenNade;

var (Bowen) class <BowenNade> BombletClass;
var (Bowen) int	NumBomblets;
var (Bowen) float upThrust;

State Exploding
{
	Begin:
		Velocity = vect(0,0,0);
		bHidden = True;
		LightType = LT_None;
		SetCollision(False, False, False);
		spawnBomblets();
		destroy();
}

// auto simulated state Flying
// {
// 	simulated function ProcessTouch(Actor Other, Vector HitLocation)
// 	{
// 		// hack
// 		 HitWall(normal(location - other.location), other);
// 	}
// }

function SpawnBomblets()
{
	local int i;
	local BowenNade bomblet;
	local vector direction;
	local float rotation;
	local bool bInnerCircle;
	
	for (i=0;i<NumBomblets;i++)
	{
		// must be deterministic otherwise networking gets awful
		// bomblet directions in a ring pointing upwards and outwards
		rotation = 2*pi*(float(i) / float(numBomblets));
		direction.X = sin(rotation);
		direction.Y = cos(rotation);
		bInnerCircle=!bInnerCircle;
		if(bInnerCircle)
			direction.Z = -0.5*upThrust;
		else
			direction.Z = upThrust;
// 		broadcastMessage("CBomb: Rot="$rotation$",X="$direction.X$",Y="$direction.Y$",Z="$direction.Z);
		bomblet = Spawn (BombletClass,Owner,,Location,rotator(direction));
		if(bInnerCircle)
		{
			bomblet.maxBounces -= 1;
			bomblet.elasticity = 0.9;
		}
		else
		{
			bomblet.speed *= 1.5;
			bomblet.blastRadius *= 2;
		}
		bomblet.velocity=normal(direction)*bomblet.speed;
	}
}

defaultproperties
{
    BombletClass=Class'Bomblet'
    NumBomblets=20
    upThrust=1.00
    numParticles=0
    bSphere=False
    bLight=False
    blastRadius=200.00
    Damage=30.00
    ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion1'
}
