//=============================================================================
// DesignatedPoint.	(c) 2003 JimBowen
//=============================================================================
class DesignatedPoint expands BowenBasicActor2
config (Bowen);

var (Bowen) float maxHeight;
var (Bowen) config float ChargeTime, LockTime, FireTime, ChargeEffectTime, ShotTime;
var (Bowen) sound LockedSound, WarmupSound, ChargingSound, FireSound;
var (Bowen) config bool bNeedSky, bReplicateProjectiles;
var bool bLocked, bCharged, bDebug;
var (Bowen) config int numShots;
var int i;
var (Bowen) class<DeusExProjectile> ProjectileClass;

var (bowen) string MsgSeen, MsgLocked, MsgFiring, MsgNoSky;

function tick (float deltatime)
{
	if(level.NetMode == NM_Client)
		return;

	if(!bLocked && !bCharged)
	{
		LockTime -= DeltaTime;
		if (LockTime <= 0)
		{
			bLocked = True;
	//		if (Level.NetMode != NM_DedicatedServer)
			   PlayLockedEffects();
			PlayerPawn(Owner).ClientMessage(MsgLocked);
		}

		if (Default.ChargeEffectTime != -1)
		{
			ChargeEffectTime -= DeltaTime;
			if(ChargeEffectTime <= 0)
			{
				ChargeEffectTime = Default.ChargeEffectTime;
		//		if (Level.NetMode != NM_DedicatedServer)
				   PlayChargeEffects();
			}
		}

	}

	if(bLocked && !bCharged)
	{
		ChargeTime -= DeltaTime;
		if (ChargeTime <= 0)
		{
			if(bDebug) BroadcastMessage("DEBUG: Going to firing state");
			ChargeTime = Default.ChargeTime;
			bCharged = True;
			PlayerPawn(Owner).ClientMessage(MsgFiring);
			GoToState('Firing');
		}
	}
}

simulated function PlayLockedEffects()
{
	// implemented in subclasses
}

simulated function PlayChargeEffects()
{
	// implemented in subclasses
}

// ----------------------------------------------------------------------
// GetRoofMaterial()
//
// gets the name of the texture group thats above us
// ----------------------------------------------------------------------

function name GetRoofMaterial(out vector RoofNormal)
{
	local vector EndTrace, HitLocation, HitNormal;
	local actor target;
	local int texFlags;
	local name texName, texGroup;

	// trace out in front of us
	EndTrace = Location + (Vect(0,0,1) * maxHeight);

 	foreach TraceTexture(class'Actor', target, texName, texGroup, texFlags, HitLocation, HitNormal, EndTrace)
	{
		if ((target == Level) || target.IsA('Mover'))
			break;
	}

	RoofNormal = HitNormal;
//	log("Tex name = " @ TexName);
//	log("Tex group = " @ TexGroup);
//	log("Tex flags = " @ TexFlags);
	return texGroup;
}

function PostBeginPlay()
{
	local vector RoofNormal;
	local name RoofMaterial;

		Super.PostBeginPlay();

		if (bNeedSky)
			RoofMaterial = GetRoofMaterial(RoofNormal);

		if (DeusExPlayer(Owner) == None)
		{
			BroadcastMessage("ERROR: No owner for designated point. Aborting!");
			Destroy();
			return;
		}

		if(!bNeedSky || RoofMaterial == 'CoreTexSky' || RoofMaterial == 'CoreTexMisc' || RoofMaterial == 'Sky')
		{
			log ("Accepted - " @ RoofMaterial);
			PlayerPawn(Owner).ClientMessage(MsgSeen);
			PlaySpawnedEffects();
		}
		else
		{
			if (Role == ROLE_Authority)
				Pawn(Owner).ClientMessage(MsgNoSky);
			log ("Not SkyBox - " @ RoofMaterial);

		//	if (Level.NetMode == NM_StandAlone && DeusExPlayer(Owner) != None)
			if(DeusExPlayer(Owner) != None && DeusExPlayer(Owner).bAdmin)
				return;
			Destroy();
		}
}

simulated function PlaySpawnedEffects()
{
	// Implemented in subclasses
}

simulated function int PlaySimSound( Sound snd, ESoundSlot Slot, float Volume, float Radius )
{
	if ( Owner != None )
	{
		if ( Level.NetMode == NM_Standalone )
			return ( Owner.PlaySound( snd, Slot, Volume, , Radius ) );
		else
		{
			Owner.PlayOwnedSound( snd, Slot, Volume, , Radius );
			return 1;
		}
	}
	return 0;
}

function vector CalcFireLoc()
{
	local vector StartTrace, EndTrace, HitNormal, Direction, Start, HitLocation;
	local actor Other;

	Start = Location;
	StartTrace = Start;
	EndTrace = Start;
	EndTrace += vect(0,0,1)*MaxHeight;
	Other = Trace(HitLocation,HitNormal,EndTrace,StartTrace,True);
	return HitLocation;
}

state Firing
{
	ignores Tick;

	begin:
	PlayFireEffects();
	sleep(FireTime/2);
	if(bDebug) BroadcastMessage("DEBUG: Firing!");
	for (i=0;i<numShots;i++)
	{
		Fire(CalcFireLoc());
		Sleep(ShotTime);
	}
	Destroy();
}

simulated function PlayFireEffects()
{
	// Implemented in subclasses
}

function DeusExProjectile Fire(vector FireLocation)
{
	local DeusExProjectile Proj;

		if(level.NetMode == NM_Client)
			return None;

		Proj = Spawn(ProjectileClass,Owner,,FireLocation,rotator(vect(0,0,-1)));
		if(bReplicateProjectiles)
			Proj.bAlwaysRelevant=True;
			
		if(bDebug) BroadcastMessage("DEBUG: Fired" @ Proj);
		Return Proj;
}

//---END-CLASS---

defaultproperties
{
    maxHeight=65536.00
    ChargeTime=10.00
    LockTime=5.00
    fireTime=5.00
    ChargeEffectTime=-1.00
    bReplicateProjectiles=True
    numShots=1
    bHidden=True
    RemoteRole=2
    bAlwaysRelevant=True
}
