//=============================================================================
// Flamethrower. 	(c) 2008 JimBowen
//=============================================================================

class Flamethrower extends BowenWeapon;

var int BurnTime, BurnDamage;

var int		mpBurnTime;
var int		mpBurnDamage;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
      HitDamage = mpHitDamage;
      BaseAccuracy=mpBaseAccuracy;
      ReloadTime = mpReloadTime;
      AccurateRange = mpAccurateRange;
      MaxRange = mpMaxRange;
      ReloadCount = mpReloadCount;
      BurnTime = mpBurnTime;
      BurnDamage = mpBurnDamage;
      PickupAmmoCount = mpReloadCount;
	}
}

defaultproperties
{
    burnTime=30
    BurnDamage=5
    mpBurnTime=15
    mpBurnDamage=2
    LowAmmoWaterMark=50
    GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
    EnviroEffective=1
    bAutomatic=True
    ShotTime=0.10
    reloadTime=5.50
    HitDamage=2
    maxRange=2000
    AccurateRange=2000
    BaseAccuracy=2.00
    AreaOfEffect=1
    bHasMuzzleFlash=False
    mpReloadTime=0.50
    mpHitDamage=5
    mpBaseAccuracy=2.00
    mpAccurateRange=320
    mpMaxRange=320
    mpReloadCount=100
    bCanHaveModAccurateRange=True
    bCanHaveModReloadTime=True
    AmmoName=Class'AmmoFlamethrower'
    ReloadCount=250
    PickupAmmoCount=250
    FireOffset=(X=0.00,Y=10.00,Z=10.00),
    ProjectileClass=Class'BowenFireball'
    shakemag=10.00
    FireSound=Sound'DeusExSounds.Weapons.FlamethrowerFire'
    AltFireSound=Sound'DeusExSounds.Weapons.FlamethrowerReloadEnd'
    CockingSound=Sound'DeusExSounds.Weapons.FlamethrowerReload'
    SelectSound=Sound'DeusExSounds.Weapons.FlamethrowerSelect'
    InventoryGroup=15
    ItemName="Flamethrower"
    PlayerViewOffset=(X=20.00,Y=-14.00,Z=-12.00),
    PlayerViewMesh=LodMesh'DeusExItems.Flamethrower'
    PickupViewMesh=LodMesh'DeusExItems.FlamethrowerPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.Flamethrower3rd'
    LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
    Icon=Texture'DeusExUI.Icons.BeltIconFlamethrower'
    largeIcon=Texture'DeusExUI.Icons.LargeIconFlamethrower'
    largeIconWidth=203
    largeIconHeight=69
    invSlotsX=4
    invSlotsY=2
    Description="The BowenCo Flamethrower improves upon the Page Industries standard napalm flamethrower with improved effective range, and a more resilient flame that will not extinguish if blocked by obstacles."
    beltDescription="ROASTER"
    Mesh=LodMesh'DeusExItems.FlamethrowerPickup'
    CollisionRadius=20.50
    CollisionHeight=4.40
    Mass=40.00
}
