//=============================================================================
// ForceRifle. 	(c) 2003 JimBowen
//=============================================================================
class ForceRifle extends BowenWeapon;

var float	mpRecoilStrength;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;

		// Tuned for advanced -> master skill system (Monte & Ricardo's number) client-side
		recoilStrength = 0.75;
	}
}

simulated function tick(float deltatime)
{
	if (Pawn(Owner) == None)
		ProjectileClass = Default.ProjectileClass;
	Super.Tick(deltatime);

}

function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
				// otherwise, set us to fire projectiles
				bInstantHit = False;
				//bAutomatic = False;	DAMN i hate your stupid habit of hard coding things like this
				if(NewAmmo.IsA('AmmoForceGrenade'))
				{
					bAutomatic = False;
					FireSound = None;	
					ShotTime = 1.0;
				}
				else
				{	
					bAutomatic = Default.bAutomatic;
					ShotTime = Default.ShotTime;
					FireSound = Default.FireSound;
				}
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				//FireSound = None;		// handled by the projectile -- NO! NOT ALWAYS!
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;
			}

			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}

	return False;
}

//---END-CLASS---

defaultproperties
{
    LowAmmoWaterMark=30
    GoverningSkill=Class'DeusEx.SkillWeaponRifle'
    EnviroEffective=1
    Concealability=1
    bAutomatic=True
    ShotTime=0.10
    reloadTime=3.00
    HitDamage=3
    BaseAccuracy=0.70
    bCanHaveLaser=True
    bCanHaveSilencer=True
    AmmoNames(0)=Class'AmmoForceRifle'
    AmmoNames(1)=Class'AmmoForceGrenade'
    ProjectileNames(0)=Class'ForceSlug'
    ProjectileNames(1)=Class'ForceGrenade'
    recoilStrength=0.50
    MinWeaponAcc=0.20
    mpReloadTime=0.50
    mpHitDamage=9
    mpBaseAccuracy=1.00
    mpAccurateRange=2400
    mpMaxRange=2400
    mpReloadCount=30
    bCanHaveModBaseAccuracy=True
    bCanHaveModReloadCount=True
    bCanHaveModAccurateRange=True
    bCanHaveModReloadTime=True
    bCanHaveModRecoilStrength=True
    AmmoName=Class'AmmoForceRifle'
    ReloadCount=30
    PickupAmmoCount=30
    FireOffset=(X=-16.00,Y=5.00,Z=11.50),
    ProjectileClass=Class'ForceSlug'
    shakemag=200.00
    FireSound=Sound'DeusExSounds.Weapons.AssaultGunFire'
    AltFireSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
    CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
    SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
    InventoryGroup=165
    ItemName="Force Rifle"
    ItemArticle="an"
    PlayerViewOffset=(X=16.00,Y=-5.00,Z=-11.50),
    PlayerViewMesh=LodMesh'DeusExItems.AssaultGun'
    PickupViewMesh=LodMesh'DeusExItems.AssaultGunPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.AssaultGun3rd'
    LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
    Icon=Texture'DeusExUI.Icons.BeltIconAssaultGun'
    largeIcon=Texture'DeusExUI.Icons.LargeIconAssaultGun'
    largeIconWidth=94
    largeIconHeight=65
    invSlotsX=2
    invSlotsY=2
    Description="The BowenCo Force rifle is able to launch enemies away from the user. It is dedigned for use in lofted environments"
    beltDescription="FORCE"
    Mesh=LodMesh'DeusExItems.AssaultGunPickup'
    CollisionRadius=15.00
    CollisionHeight=1.10
    Mass=30.00
}
