//=============================================================================
// HelixRocket. 	(c) 2005 JimBowen
//=============================================================================
class HelixRocket expands Rocket;

// var vector Direction;	// the direction we are currently spiralling in
var vector pR;			// the vector from the centre of the helix to this rocket
var vector Omega;		// angular velocity
var vector vR;			// radial velocity
var (Bowen) bool bDebug, bDisableTwirl;
var vector lastR;
var vector OrigVelocity;
var int ID;

auto state Flying
{
	function tick (float deltaTime)
	{
		if (bDisableTwirl || DeltaTime > 0.4)
			return;
	//	if (Velocity dot OrigVelocity == 0)
	//		Explode(Location, vect(0,0,1));

		pR += vR * DeltaTime;
		vR -= (Omega dot Omega) * pR * DeltaTime;
		Velocity = OrigVelocity + vR;
		
		if(bDebug)
		{
			Log("HelixRocket ID = " $ ID, 'DEBUG');
			Log("HelixRocket velocity = " $ velocity, 'DEBUG');
			Log("HelixRocket pR = " $ pR, 'DEBUG');
			Log("HelixRocket vR = " $ vR, 'DEBUG');
			Log("HelixRocket pRDiff = " $ VSize(pR - LastR), 'DEBUG');
			Log("HelixRocket Radius = " $ VSize(pR), 'DEBUG');
			Log("HelixRocket DTime = " $ DeltaTime, 'DEBUG');
			Log("HelixRocket Theta = " $ Velocity dot OrigVelocity, 'DEBUG');
			Log("HelixRocket Phi = " $ Velocity cross OrigVelocity, 'DEBUG');
			Log("", 'DEBUG');
			LastR = pR;
		}
	}
}

//---END-CLASS---

defaultproperties
{
}
