//=============================================================================
// HomingMissile. 	(c) 2003 JimBowen
//=============================================================================
class HomingMissile expands Rocket;

var(Bowen) int SearchRadius;
var(Bowen) bool bLoseLock;
var(Bowen) float AquireFOV, MaintainFOV;
var rotator NewRotation;
var vector NewVelocity, NewLocation;
var pawn LockPawn;

replication
{
	reliable if (Role == ROLE_Authority)
		LockPawn, bLoseLock;

	unreliable if (Role == ROLE_Authority)
		NewRotation, NewVelocity, NewLocation;
}


simulated function setdirection()
{
	NewRotation = (PlayerPawn(Owner).ViewRotation);
	NewVelocity = normal(vector(NewRotation))*speed;
	NewLocation = Location;
	//log("rotation to set (nikita) = " @ NewRotation);
}

simulated function tick (float deltatime)
{
	local float fangle;
	local vector vvect, dvect;
		
		if (!Owner.IsA('DeusExPlayer'))
			return;
			
			if (owner == None)
			{
				log ("No owner on HomingMissile, aborting!");
				Destroy();
				return;
			}
			
		CheckRadius();
		Target = LockPawn;
				
		if (LockPawn != None)
		{
			vvect = normal(Velocity);
			dvect = normal(LockPawn.Location - Location);
			fangle = Acos(vvect dot dvect);
			if (fangle > MaintainFOV)
				LockPawn = None;
		}

		if((Role == ROLE_Authority || bNetOwner) && Level.NetMode != NM_StandAlone)	//dont do this on clients that didnt fire the rocket										
		{
		//	if(!bExploded)
		//	{
			/*	if (bNetOwner)
				{
					if (FireGen != None)
						FireGen.Destroy();
					if (SmokeGen != None)
						SmokeGen.LifeSpan = 5;
					bDebris = False;
				}*/
				//MakeWindow();
				SetDirection();
				SetRotation(NewRotation);
				Velocity = NewVelocity;
				//log("Nikita ticked");
		//	}
		}
		if(Role < ROLE_Authority && !bNetOwner)
		{
			SetRotation(NewRotation);
			Velocity = NewVelocity;
			SetLocation(NewLocation);
			SmokeGen.SetLocation(NewLocation);
			FireGen.SetLocation(NewLocation);
			//log("Nikita ticked on observing client, new rotation is: " @ NewRotation);
		}
		//log("Role = " @ Role @ ", bNetOwner = " @ bNetOwner); 
		Super.tick(DeltaTime);
			
		//Super.Tick (DeltaTime);

}

function CheckRadius()
{
	local pawn p;
	local actor a;
	local float fangle;
	local vector vvect, dvect;
	local int mostKills;
	local PlayerReplicationInfo PRI;
	local PlayerReplicationInfo ownerPRI;

		foreach visibleactors (class 'pawn', p, SearchRadius)
		{
			if (p != None && LockPawn == None && p != Owner && !p.IsInState('Dying'))
			{
				vvect = normal(Velocity);
				dvect = normal(p.Location - Location);
				fangle = Acos(vvect dot dvect);
				if (p.IsA('DeusExPlayer')) PRI = DeusExPlayer(p).PlayerReplicationInfo;
				if (Owner.IsA('DeusExPlayer')) ownerPRI = DeusExPlayer(Owner).PlayerReplicationInfo;
// 				log(fAngle);
				if (fangle < AquireFOV)
				{
					if (TeamDMGame(DeusExPlayer(Owner).DXGame) != None)
					{	
						if (PRI != None && pri.Team != OwnerPRI.Team && PRI.score > mostKills)
						{
							LockPawn = p;
							mostKills = PRI.Score;
						}
					}
					else if (Level.NetMode != NM_Standalone)
					{
						if (PRI != None && PRI.score > mostKills)
						{
							LockPawn = p;
							mostKills = PRI.Score;
						}
					}
					else if (p.IsA('ScriptedPawn'))
					{
						if((ScriptedPawn(P).IsValidEnemy(Pawn(Owner), True)) || P.IsA('Animal') || Level.NetMode != NM_StandAlone)
						{
							LockPawn = p;
							break;
						}
					}
				}
			}
		}
						
// 		foreach visibleactors (class 'actor', a, SearchRadius * 1.45)
// 			if (a != None)
// 				if (a.IsA('DeflectorGrenade'))
// 					LockPawn = None;
	
					
		if (LockPawn != None) bTracking = True;
		else if(bLoseLock) bTracking = False;
					
}


static final function float ACos  ( float A )	// thanks to UnrealWiki for this
{
  if (A>1||A<-1) //outside domain!
    return 0;
  if (A==0) //div by 0 check
    return (Pi/2.0);
  A=ATan(Sqrt(1.0-Square(A))/A);
  if (A<0)

    A+=Pi;
  Return A;
}

//---END-CLASS---

defaultproperties
{
    SearchRadius=1000
    AquireFOV=0.87
    MaintainFOV=1.75
    mpBlastRadius=320.00
    ItemName="Heat-Seeking Missile"
    speed=1800.00
    MaxSpeed=2500.00
    Damage=500.00
    bAlwaysRelevant=True
}
