//=============================================================================
// IncendiaryBall.
//=============================================================================
class IncendiaryBall extends BowenNade;

var ParticleGenerator smokeGen, fireGen;

simulated function SpawnSmokeEffects()
{
	Super.SpawnSmokeEffects();
	fireGen = Spawn(class'ParticleGenerator', Self);
	if (fireGen != None)
	{
		fireGen.particleTexture = FireTexture'Effects.Fire.Flame_J';
		fireGen.particleDrawScale = 0.5;
		fireGen.checkTime = 0.001;
		fireGen.riseRate = 0.0;
		fireGen.ejectSpeed = 10;
		fireGen.particleLifeSpan = 0.8;
		fireGen.bRandomEject = True;
		fireGen.SetBase(Self);
      fireGen.RemoteRole = ROLE_None;
	}
}

simulated function Destroyed()
{
	if (fireGen != None)
		fireGen.DelayedDestroy();
	Super.Destroyed();
}


defaultproperties
{
    ExplosionTime=0.30
    EffectsTime=1.00
    particleModifier=0.40
    particleTexture=FireTexture'Effects.Fire.flame_b'
    ParticleClass=Class'FireSprite'
    numParticles=100
    blastRadius=300.00
    DamageType=Flamed
    AccurateRange=1000
    bIgnoresNanoDefense=True
    ItemName="Incendiary cannon"
    ItemArticle="an"
    speed=3000.00
    Damage=60.00
    ImpactSound=Sound'DeusExSounds.Generic.SmallExplosion2'
    ExplosionDecal=Class'DeusEx.ScorchMark'
    Mesh=LodMesh'DeusExDeco.Tumbleweed'
    DrawScale=0.80
    AmbientSound=Sound'DeusExSounds.Weapons.WPApproach'
    CollisionRadius=15.00
    CollisionHeight=15.00
    bBounce=False
}
