//=============================================================================
// InterceptorMissile.
//=============================================================================
class InterceptorMissile extends Rocket;

auto simulated state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if (Other.IsA('DeusExProjectile'))
			if(!DeusExProjectile(Other).bIgnoresNanoDefense)
			{
				DeusExProjectile(Other).Explode(HitLocation, vect(0,0,0));
				Explode(HitLocation, vect(0,0,0));
			}
		Super.ProcessTouch(Other, HitLocation);
	}
}


simulated function ProcessTouch (Actor Other, Vector HitLocation)
{
	if (Other.IsA('DeusExProjectile'))
		if(!DeusExProjectile(Other).bIgnoresNanoDefense)
		{
			DeusExProjectile(Other).Explode(HitLocation, vect(0,0,0));
			Explode(HitLocation, vect(0,0,0));
		}
	Super.ProcessTouch(Other, HitLocation);
}

defaultproperties
{
    blastRadius=10.00
    maxRange=10000
    bTracking=False
    speed=4000.00
    MaxSpeed=5000.00
    Damage=5.00
    MomentumTransfer=5000
    SpawnSound=Sound'DeusExSounds.Robot.RobotFireRocket'
    Mesh=LodMesh'DeusExItems.RocketLAW'
    CollisionRadius=10.00
    CollisionHeight=10.00
    bBlockActors=True
    bProjTarget=True
}
