//================================================
//  LocatorDart --- Idea contributed by Batch_File
//================================================

class LocatorDart extends DeusExProjectile;

var float mpDamage;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	if ( Level.NetMode != NM_Standalone )
		Damage = mpDamage;
		
	if (DeusExPlayer(Owner) != None && !DeusExRootWindow(DeusExPlayer(Owner).rootWindow).actorDisplay.IsA('LocatorWindow'))
	{
		Pawn(Owner).ClientMessage("Spawning new locatorwindow");
		DeusExRootWindow(DeusExPlayer(Owner).rootWindow).actorDisplay = ActorDisplayWindow(DeusExRootWindow(DeusExPlayer(Owner).rootWindow).NewChild(Class'LocatorWindow'));
		DeusExRootWindow(DeusExPlayer(Owner).rootWindow).actorDisplay.SetWindowAlignments(HALIGN_Full, VALIGN_Full);
	}
	
}

auto simulated state flying
{
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		local LocatorBeacon loc;
		loc = Spawn(class'LocatorBeacon',Owner,,Other.Location);
		loc.setBase(Other);
		Other.bAlwaysRelevant=True;
		Super.ProcessTouch(Other, HitLocation);
	}
	
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		local LocatorBeacon loc;
		loc = Spawn(class'LocatorBeacon',Owner,,Wall.Location);
		loc.setBase(Wall);
		LifeSpan=1;
		Super.HitWall(HitNormal, Wall);
	}
}

defaultproperties
{
    mpDamage=2.00
    bBlood=True
    bStickToWall=True
    DamageType=shot
    bIgnoresNanoDefense=True
    ItemName="Bowen Locator Dart"
    ItemArticle="a"
    speed=2000.00
    MaxSpeed=3000.00
    Damage=5.00
    MomentumTransfer=1000
    ImpactSound=Sound'DeusExSounds.Generic.BulletHitFlesh'
    Mesh=LodMesh'DeusExItems.Dart'
    CollisionRadius=3.00
    CollisionHeight=0.50
}
