//=============================================================================
// MBController. 	(c) 2003 JimBowen
//=============================================================================
class MBController expands BowenWeapon;

simulated function processtracehit(actor other, vector hitlocation, vector hitnormal, vector x, vector y, vector z)
{
	local Pawn p;
	if (Other.IsA('MBDecoration'))
		MBDecoration(other).Activate(DeusExPlayer(Owner));
	
	else if (Other.IsA('MiniBot') && Other.Owner == Owner)
		MiniBot(Other).Deactivate();
		
	else if (Other.isA('Pawn'))
	{
		for (p=Level.PawnList; p!=None; p=p.nextPawn)
			if (p.IsA('MiniBot') && p.Owner == Owner)
				MiniBot(p).setTarget(Pawn(Other));
	}
	
	else
	{
		for (p=Level.PawnList; p!=None; p=p.nextPawn)
			if (p.IsA('MiniBot') && p.Owner == Owner)
				MiniBot(p).navigateTo(hitLocation);
	}
}

state NormalFire
{
Begin:
	if ((ClipCount >= ReloadCount) && (ReloadCount != 0))
	{
		if (!bAutomatic)
		{
			bFiring = False;
			FinishAnim();
		}

		if (Owner != None)
		{
			if (Owner.IsA('DeusExPlayer'))
			{
				bFiring = False;

				// should we autoreload?
				if (DeusExPlayer(Owner).bAutoReload)
				{
					// auto switch ammo if we're out of ammo and
					// we're not using the primary ammo
					if ((AmmoType.AmmoAmount == 0) && (AmmoName != AmmoNames[0]))
						CycleAmmo();
					ReloadAmmo();
				}
				else
				{
					if (bHasMuzzleFlash)
						EraseMuzzleFlashTexture();
					GotoState('Idle');
				}
			}
			else if (Owner.IsA('ScriptedPawn'))
			{
				bFiring = False;
				ReloadAmmo();
			}
		}
	}
	if ( bAutomatic && (( Level.NetMode == NM_DedicatedServer ) || ((Level.NetMode == NM_ListenServer) && Owner.IsA('DeusExPlayer') && !DeusExPlayer(Owner).PlayerIsListenClient())))
		GotoState('Idle');

	Sleep(GetShotTime());
	if (bAutomatic)
	{
		GenerateBullet();	// In multiplayer bullets are generated by the client which will let the server know when
		Goto('Begin');
	}
	bFiring = False;
	FinishAnim();

/*	// if ReloadCount is 0 and we're not hand to hand, then this is a
	// single-use weapon so destroy it after firing once
	if ((ReloadCount == 0) && !bHandToHand)
	{
		if (DeusExPlayer(Owner) != None)
			DeusExPlayer(Owner).RemoveItemFromSlot(Self);   // remove it from the inventory grid
		Destroy();
	}
	*/ 		// Do i REALLY need all that crap JUST for infinite ammo?
	ReadyToFire();
Done:
	bFiring = False;
	Finish();
}

//---END-CLASS---

defaultproperties
{
    Concealability=3
    bAutomatic=True
    ShotTime=0.10
    reloadTime=0.00
    HitDamage=1
    maxRange=960000
    BaseAccuracy=0.00
    AmmoName=Class'DeusEx.AmmoNone'
    ReloadCount=0
    bInstantHit=True
    shakemag=0.00
    FireSound=Sound'DeusExSounds.Generic.Beep1'
    ItemName="MiniBot controller"
    PlayerViewOffset=(X=20.00,Y=-10.00,Z=-16.00),
    PlayerViewMesh=LodMesh'DeusExItems.MultitoolPOV'
    PickupViewMesh=LodMesh'DeusExItems.Multitool'
    ThirdPersonMesh=LodMesh'DeusExItems.Multitool3rd'
    LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
    Icon=Texture'DeusExUI.Icons.BeltIconMultitool'
    largeIcon=Texture'DeusExUI.Icons.LargeIconMultitool'
    largeIconWidth=28
    largeIconHeight=46
    Description="A remote control device for the BowenCo MiniBot"
    beltDescription="Controller"
    Mesh=LodMesh'DeusExItems.Multitool'
    CollisionRadius=4.80
    CollisionHeight=0.86
    Mass=20.00
    Buoyancy=10.00
}
