//=============================================================================
 // MBDecoration. 	(c) 2003 JimBowen
 //=============================================================================

 class MBDecoration expands DeusExDecoration;

 var(Bowen) float RespawnTime;
 var vector originallocation;
 var bool bSpawned;
 var MiniBot Bot;

 replication
 {
 	reliable if (Role == ROLE_Authority)
 		OriginalLocation, bSpawned;
 }

 function PostBeginPlay()
 {
 	OriginalLocation = Location;
 }

 function Activate(DeusExPlayer Activator)
 {
 	bHidden = True;
 	SetCollision(False);
 	Bot = Spawn(class'MiniBot', Activator,, Location, Rotation);
 	Bot.PlayerOwner = Activator;
 	Bot.Health = HitPoints;
 	bot.HealthTorso = HitPoints;
 	Bot.Alliance = Activator.Alliance;
 	if(!bSpawned)
 		SetTimer(RespawnTime, False);	
 }

 function timer()
 {
 	if(Bot == None)
 	{
 		if(bHidden)	
 		{
 			SetLocation(Originallocation);
 			bHidden = False;
 			SetCollision(True);
 		}
 	}
 	else
 		SetTimer(RespawnTime/10, False);
 }

 //---END-CLASS---

defaultproperties
{
    RespawnTime=60.00
    HitPoints=5000
    bInvincible=True
    bExplosive=True
    explosionRadius=300.00
    RemoteRole=2
    Mesh=LodMesh'DeusExCharacters.SecurityBot4'
    bAlwaysRelevant=True
    CollisionRadius=25.00
    CollisionHeight=25.00
    bBlockActors=False
    bProjTarget=True
    Mass=30.00
    FamiliarName="BowenCo MiniBot"
    UnfamiliarName="BowenCo MiniBot"
}
