//=============================================================================
// NukeSphere.
//=============================================================================
class NukeSphere expands Effects;

var float AliveTime;
var bool bWaning;

simulated function Tick(float deltaTime)
{
	if (AliveTime > (Default.LifeSpan / 2))
		bWaning = True;
		
	if (!bWaning)
		Alivetime += 3*Deltatime;
	else
		Alivetime -= Deltatime;
		
	//log(AliveTime);
	
	ScaleGlow = 2.0 * AliveTime/Default.LifeSpan;
}

//---END-CLASS---

defaultproperties
{
    LifeSpan=15.00
    DrawType=2
    Style=3
    Skin=Texture'Extension.CheckboxOff'
    Mesh=LodMesh'DeusExItems.SphereEffect'
    MultiSkins=Texture'Extension.CheckboxOff'
}
