//=============================================================================
// DesignatedPoint.	(c) 2003 JimBowen
//=============================================================================
class OsirisPoint expands DesignatedPoint;

var (Bowen) float ChargeRingTime;
var (Bowen) Texture ChargeRingTex, SkySpriteTex, SkySpriteTex2, CentreLockRingTex, OuterLockRingTex;
var BowenSpriteFlat Centre, Outer;

simulated function PlaySpawnedEffects()
{
	local ParticleGenerator FlareGen;
	local TeleportInhibitor Inhibitor;

	Inhibitor = Spawn(class'TeleportInhibitor',,,Location);
	Inhibitor.LifeSpan = ChargeTime + LockTime + FireTime + 15;
	Inhibitor.EffectRadius = 3000;
	Inhibitor = Spawn(class'TeleportInhibitor',,,Location);
	Inhibitor.LifeSpan = ChargeTime + LockTime + FireTime + 15;
	Inhibitor.EffectRadius = 1000;
	Inhibitor.bNoLOS = True;

	FlareGen = Spawn(class'ParticleGenerator',,,(Location + vect(0,0,3)),Rotator(vect(0,0,1)));
	if (FlareGen != None)
	{
		FlareGen.particleTexture = Texture'Effects.laser.LaserSpot1';
		FlareGen.particleDrawScale = 2;
		FlareGen.bRandomEject = True;
		FlareGen.ejectSpeed = 1000.0;
		FlareGen.bGravity = True;
		FlareGen.bParticlesUnlit = True;
		FlareGen.frequency = 3;
		FlareGen.riseRate = 10;
		FlareGen.spawnSound = Sound'Spark2';
		FlareGen.LifeSpan = 2;
		FlareGen.Checktime = 0;
	}
}

simulated function PlayLockedEffects()
{
	PlaySimSound (LockedSound, SLOT_None, TransientSoundVolume, 2048);
	Centre = Spawn(class'BowenSpriteFlat',,,(Location + 2*vector(Rotation)),Rotation);
	Outer = Spawn(class'BowenSpriteFlat',,,Location + vector(Rotation),Rotation);
	Centre.bRotate = True;
	Centre.RotationSpeed = 60;
	Centre.Skin = CentreLockRingTex;
	Outer.bRotate = True;
	Outer.RotationSpeed = -60;
	Outer.Skin = OuterLockRingTex;
}

simulated function PlayChargeEffects()
{
	local ShockRing ChargeRing;

	ChargeRing = Spawn(class'ShockRing',,, Location + vector(Rotation), Rotation);
	ChargeRing.Skin = ChargeRingTex;
	PlaySimSound(ChargingSound, SLOT_None, TransientSoundVolume, 2048);
}

simulated function PlayFireEffects()
{
	local SkyZoneInfo Sky;
	local SphereEffect Sph;
	local NukeSphere Nuke;
	local AnimatedSprite spri;

		PlaySimSound(WarmupSound, SLOT_None, TransientSoundVolume, 2048);

		foreach allactors (class'SkyZoneInfo', Sky)
			if (Sky != None)
			{
				Sph = Spawn(class'SphereEffect',,,Sky.Location);
					Sph.Skin = SkySpriteTex;
					Sph.Size = 3;
					Sph.lifeSpan = 15;
					Sph.bAlwaysRelevant = True;

				Nuke = Spawn(class'NukeSphere',,,Sky.Location);
					Nuke.Skin = SkySpriteTex2;
					Nuke.lifeSpan = 15;
					Nuke.bAlwaysRelevant = True;
			}
}

simulated function Destroyed()
{
	if(Centre != None)
		Centre.Destroy();
	if(Outer != None)
		Outer.Destroy();
}

simulated function SpawnSkyboxSprite()
{
	local SkyZoneInfo Sky;
	local SphereEffect Sph;
	local NukeSphere Nuke;
	local AnimatedSprite spri;
	
		foreach allactors (class'SkyZoneInfo', Sky)
			if (Sky != None)
			{
				Sph = Spawn(class'SphereEffect',,,Sky.Location);
					Sph.Skin = SkySpriteTex;
					Sph.Size = 3;
					Sph.lifeSpan = 15;
					Sph.bAlwaysRelevant = True;

				Nuke = Spawn(class'NukeSphere',,,Sky.Location);
					Nuke.Skin = SkySpriteTex2;
					Nuke.lifeSpan = 15;
					Nuke.bAlwaysRelevant = True;
			}
}

function DeusExProjectile Fire(vector FireLocation)
{
	local DeusExProjectile Proj;

		if(level.NetMode == NM_Client)
			return None;

		Proj = Spawn(ProjectileClass,Owner,,FireLocation,rotator(vect(0,0,-1)));
		if(bReplicateProjectiles)
			Proj.bAlwaysRelevant=True;
		if(i == 0 && OsirisPlasmaBall(Proj) != None)
			OsirisPlasmaBall(Proj).bDamageSpawner = True;
		if(bDebug) BroadcastMessage("DEBUG: Fired" @ Proj);
		Return Proj;
}



//---END-CLASS---

defaultproperties
{
    ChargeRingTex=Texture'DeusExItems.Skins.FlatFXTex43'
    SkySpriteTex2=Texture'Extension.CheckboxOff'
    ChargeEffectTime=2.00
    ShotTime=0.25
    numShots=50
    ProjectileClass=Class'OsirisPlasmaBall'
    MsgSeen="|p2Osiris satellite has seen the target, and is turning to position."
    msgLocked="|p2Osiris satellite is in position and initialising weapon systems."
    MsgFiring="|p2Osiris satellite is firing a plasma stream at the target."
    MsgNoSky="|p2Point untargettable. No sky above designated point."
}
