//=============================================================================
// PlasmaGlow. 	(c) 2008 JimBowen
//=============================================================================
class PlasmaGlow expands DeusExDecal;

var (Bowen) float updateTime;
var float initialDrawScale, initialLifeSpan;
var float updateTimer;

simulated function PreBeginPlay()
{
	initialDrawScale=DrawScale;
	initialLifeSpan=LifeSpan;
	Super.PreBeginPlay();
}

simulated function Tick(float deltaTime)
{
	updateTimer += deltaTime;
	DrawScale = FClamp(initialDrawScale * (LifeSpan / initialLifeSpan), 0.1, 3);
	if(updateTimer > updateTime)
	{
		updateTimer = 0;
 		detachDecal(); // LOL AHX
 		attachDecal(100); 
	}
}

//---END-CLASS---

defaultproperties
{
    updateTime=0.40
    MultiDecalLevel=2
    LifeSpan=5.00
    Style=3
    Texture=Texture'BowenData.Effects.PlasmaGlow'
    bUnlit=False
}
