//=============================================================================
// ProjectileTurret. -- Predicts future position of target based on velocity
//=============================================================================
class ProjectileTurret extends AutoTurret;

var() bool bInterceptPriority;			// do we shoot down rockets before we shoot enemies?
var() float ProjectileSpeed, InterceptorSpeed, InterceptorRate, Tolerance;
var() bool bTrackProjectiles; //shoot down missiles?
var() bool bTriggerHappy; //fire any time we have a target, wether we are facing it or not - nice for flamethrower >:)
var() bool bInterceptThreatsOnly; // only shoot at rockets if they are headed our way
var() class<DeusExProjectile> ProjectileClass, InterceptorClass;

var bool bFireInterceptor, bDebug;
var LaserEmitter targetingLaser;

Auto state Active
{
}

function Tick(float deltaTime)
{
	local Pawn pawn;
	local ScriptedPawn sp;
	local DeusExDecoration deco;
	local float near, UseProjSpeed;
	local Rotator destRot;
	local bool bSwitched;
	local DeusExProjectile Proj;
	local vector destDir, InterceptPoint, Z, V, IntDirA, IntDirB;

	if (bDebug)
		Log("PTStartTick");

	bStasis=False;


	if(targetingLaser != None)
	{
		if(Target != none && !targetingLaser.bIsOn)
			targetingLaser.turnOn();
		if(Target == none && targetingLaser.bIsOn)
			targetingLaser.turnOff();
	}

 	if (Gun == None)
	{
		log("ProjTurret: Wtf! No gun!");
		Destroy();
		return;
	}

//	Super.Tick(deltaTime);

	bSwitched = False;

	if ( bSwitching )
	{
		UpdateSwitch();
		return;
	}

	// Make sure everything is valid and account for when players leave or switch teams
	if ( !bDisabled && (Level.NetMode != NM_Standalone) )
	{
		if ( safeTarget == None )
		{
			bDisabled = True;
			bComputerReset = False;
		}
		else
		{
			if ( DeusExPlayer(safeTarget) != None )
			{
				if ((TeamDMGame(DeusExPlayer(safeTarget).DXGame) != None) && (DeusExPlayer(safeTarget).PlayerReplicationInfo.team != team))
					bSwitched = True;
				else if ((DeathMatchGame(DeusExPlayer(safeTarget).DXGame) != None ) && (DeusExPlayer(safeTarget).PlayerReplicationInfo.PlayerID != team))
					bSwitched = True;
				
				if ( bSwitched )
				{
					bDisabled = True;
					safeTarget = None;
					bComputerReset = False;
				}
			}
		}
	}
	if ( bDisabled && (Level.NetMode != NM_Standalone) )
	{
		team = -1;
		safeTarget = None;
		if ( !bComputerReset )
		{
			gun.ResetComputerAlignment();
			bComputerReset = True;
		}
	}

	if (bConfused)
	{
		confusionTimer += deltaTime;

		// pick a random facing
		if (confusionTimer % 0.25 > 0.2)
		{
			gun.DesiredRotation.Pitch = origRot.Pitch + (pitchLimit / 2 - Rand(pitchLimit));
			gun.DesiredRotation.Yaw = Rand(65535);
		}
		if (confusionTimer > confusionDuration)
		{
			bConfused = False;
			confusionTimer = 0;
			confusionDuration = Default.confusionDuration;
		}

	}

	if (!bDisabled)
	{
		curTarget = None;

		if ( !bConfused )
		{
			if (TargetRefreshTime < 0)
				TargetRefreshTime = 0; 
			TargetRefreshTime = TargetRefreshTime + deltaTime;
	
			if (TargetRefreshTime >= 0.3)
			{
				TargetRefreshTime = 0;
				findTarget();
				if (( curTarget != prevTarget ) && ( curTarget == None ))
				{
					PlaySound(Sound'TurretUnlocked', SLOT_Interact, 1.0,, maxRange );
					if(bDebug) BroadcastMessage("PT Targ null:" @ prevTarget @ "->" @ curTarget);
				}
				prevtarget = curtarget;
			}
			else
			{
				curTarget = prevtarget;
			}
		}
	}
	else
	{
		if ( !bConfused )
			gun.DesiredRotation = origRot;
		
		if (Gun == None)
		{
		log("ProjTurret: Wtf! No gun!");
			Destroy();
			return;
		}
	}
	
	// if we have a target, rotate to face it
	if (curTarget != None)
	{
		//JimBowen- Added code to calculate the interception point of the projectile with the target, and shoot at that instead.
	
		if(curtarget.IsA('Projectile'))
			bFireInterceptor=True;

		if(bFireInterceptor)
			UseProjSpeed = InterceptorSpeed;
		else
			UseProjSpeed = ProjectileSpeed;

		DestDir = CalcIntercept(Gun.Location, CurTarget.Location, CurTarget.Velocity, UseProjSpeed, MaxRange, bDebug);
		DestRot = Rotator(DestDir);
		
		if (Gun == None)
		{
			log("Wtf! No gun!");
			Destroy();
			return;
		}

		gun.DesiredRotation = destRot;
		near = pitchLimit / 2;
		gun.DesiredRotation.Pitch = FClamp(gun.DesiredRotation.Pitch, origRot.Pitch - near, origRot.Pitch + near);
	}
	else
		gun.DesiredRotation = origRot;	

 	if (Gun == None)
	{
		log("ProjTurret: Wtf! No gun!");
		Destroy();
		return;
	}

	near = (Abs(gun.Rotation.Pitch - gun.DesiredRotation.Pitch)) % 65536;
	near += (Abs(gun.Rotation.Yaw - gun.DesiredRotation.Yaw)) % 65536;

	if (bActive && !bDisabled)
	{
		// play an alert sound and light up
		if ((curTarget != None) && (curTarget != LastTarget))
		{	
			PlaySound(Sound'Beep6',,,, 1280);
			if(bDebug) BroadcastMessage("PT LTarg change:" @ LastTarget @ "->" @ curTarget);
		}

		// if we're aiming close enough to our target
		if (curTarget != None)
		{
			gun.MultiSkins[1] = Texture'RedLightTex';
			if ((near < 4096*Tolerance) && (((Abs(gun.Rotation.Pitch - destRot.Pitch)) % 65536) < 8192*Tolerance) || bTriggerHappy)
			{
				if ((!bfireInterceptor && fireTimer > fireRate) || bfireInterceptor && fireTimer > InterceptorRate)
				{
					Fire();
					fireTimer = 0;
				}
			}
		}
		else
		{
			if (gun.IsAnimating())
				gun.PlayAnim('Still', 10.0, 0.001);

			if (bConfused)
				gun.MultiSkins[1] = Texture'YellowLightTex';
			else
				gun.MultiSkins[1] = Texture'GreenLightTex';
		}

		fireTimer += deltaTime;
		LastTarget = curTarget;
	}
	else
	{
		if (gun.IsAnimating())
			gun.PlayAnim('Still', 10.0, 0.001);
		gun.MultiSkins[1] = None;
	}

	Tolerance = Default.Tolerance;

	// make noise if we're still moving
	if (near > 64)
	{
		gun.AmbientSound = Sound'AutoTurretMove';
		if (bConfused)
			gun.SoundPitch = 128;
		else
			gun.SoundPitch = 64;
	}
	else
		gun.AmbientSound = None;

	bFireInterceptor = False;

	if (bDebug)
		Log("EndTick");

}
	
function findTarget()
{
	local Actor a;
	local Vector dist;
	
//	if(!bActive)
//		return;
	if (bSwitching)
		return;

	//DEUS_EX AMSD See if our old target is still valid.
	if (pawn(prevtarget) != None && prevtarget != safetarget)
	{
		if (Pawn(prevtarget).AICanSee(self, 1.0, false, false, false, true) > 0)
		{
			if ((DeusExPlayer(prevtarget) == None) && !prevtarget.bHidden )
			{
				dist = prevtarget.Location - gun.Location;
				if (VSize(dist) < maxRange )
				{
					considerTarget(PrevTarget);
				}
			}
			else
			{
				if (DeusExPlayer(prevtarget) != None && (DeusExPlayer(prevtarget).AugmentationSystem.GetAugLevelValue(class'AugRadarTrans') == -1.0) 
				&& !DeusExPlayer(prevtarget).bHidden )
				{
					dist = DeusExPlayer(prevtarget).Location - gun.Location;
					if (VSize(dist) < maxRange )
					{
						considerTarget(PrevTarget);
					}
				}
			}
		}
	}
	
	findPlayer();
	if(bDebug && curTarget != None) BroadcastMessage("Found a player target:" @ curTarget);
	
	foreach VisibleActors(class'Actor', a, maxRange, gun.Location)
	{
		if(a.isA('ScriptedPawn') && curTarget == none && ScriptedPawn(a).bDetectable && !ScriptedPawn(a).bIgnore 
				&& (ScriptedPawn(a).GetPawnAllianceType(GetPlayerPawn()) != ALLIANCE_Hostile) && !ScriptedPawn(a).IsA('Fly'))
			considerTarget(a);
		else if(!bTrackPawnsOnly && a.isA('DeusExDecoration') && !a.IsA('ElectronicDevices') && !a.IsA('AutoTurret') &&
				!DeusExDecoration(a).bInvincible && DeusExDecoration(a).bDetectable && !DeusExDecoration(a).bIgnore && curTarget == None)
			considerTarget(a);
		else if(a.isA('DeusExProjectile') && bTrackProjectiles && !DeusExProjectile(a).bIgnoresNanoDefense && DeusExProjectile(a).ItemName != TitleString 
				&& (projWillHitMe(DeusExProjectile(a)) || !bInterceptThreatsOnly) && (curTarget == None || bInterceptPriority))
			considerTarget(a);
	}
	if(bDebug)
		BroadcastMessage("PT_Target=" @ curTarget);
}

function findPlayer()
{
	local DeusExPlayer foundPlayer;
	local Pawn apawn;
	local DeusExPlayer aplayer;
	local vector dist;

	apawn = gun.Level.PawnList;
	while ( apawn != None )
	{
		if (apawn.bDetectable && !apawn.bIgnore && apawn.IsA('DeusExPlayer'))
		{
			aplayer = DeusExPlayer(apawn);

			dist = aplayer.Location - gun.Location;

			if ( VSize(dist) < maxRange )
			{
				// Only players we can see
				if ( aplayer.FastTrace( aplayer.Location, gun.Location ))
				{
					//only shoot at players who aren't the safetarget.
					//we alreayd know prevtarget not valid.
					if ((aplayer != safeTarget) && (aplayer != prevTarget))
					{
						if (Level.NetMode != NM_Standalone && Role == ROLE_Authority)
						{
							if (! ( (TeamDMGame(aplayer.DXGame) != None) &&	(safeTarget != None) &&	(TeamDMGame(aplayer.DXGame).ArePlayersAllied( DeusExPlayer(safeTarget),aplayer)) ) )
							{
								// If the player's RadarTrans aug is off, the turret can see him
								if ((aplayer.AugmentationSystem.GetAugLevelValue(class'AugRadarTrans') == -1.0) && !aplayer.bHidden )
									considerTarget(apawn);
							}
						}
						else if ( Level.NetMode == NM_StandAlone)
						{
							if (bTrackPlayersOnly || (!bTrackPlayersOnly && !bTrackPawnsOnly) && bActive)
							{
								if (apawn.bDetectable && !apawn.bIgnore)
								{
									// If the player's RadarTrans aug is off, the turret can see him
									if (DeusExPlayer(apawn).AugmentationSystem.GetAugLevelValue(class'AugRadarTrans') == -1.0)
										considerTarget(apawn);
								}
							}
						}
					}
				}
			}
		}
		apawn = apawn.nextPawn;
	}
}

function int rankTarget(actor a) // lower is better, i.e. higher priority to be shot
{
	local actor bestTarget;
	local int rank;
	
	if (a == none)
		return 15;
	
	if(a.isA('DeusExProjectile'))
	{
		if(bInterceptPriority && projWillHitMe(DeusExProjectile(a)))
			return 1;
		else return 5;
	}
	if(a.isA('DeusExPlayer'))
		return 3;
	if(a.isA('ScriptedPawn'))
	{
		if(ScriptedPawn(a).bOnFire) //they are running around screaming, and therefore pretty harmless :)
									//but this is really for added evilness with the flame turret >:)
			return 6;
		else return 4;
	}
}

function considerTarget(actor a)
{
	if (rankTarget(a) < rankTarget(prevTarget))
	{
		BroadcastMessage("PT RTarg change:" @ prevTarget $ "(" $ rankTarget(prevTarget) $ ")" @ "outranked by" @ a $ "(" $ rankTarget(a) $ ")");
		curtarget = a;
		PlaySound(Sound'TurretLocked', SLOT_Interact, 1.0,, maxRange );
	}
	else curTarget = prevTarget;
	prevTarget = curTarget;
}


static final function vector CalcIntercept (vector GunLocation, vector TargetLocation, vector TargetVelocity, float UseProjectileSpeed, optional float MaxRange, optional bool bDebug)
{

	local vector z, v, IntDirA, IntdirB, IntDir;
	local float kA, kB, a, b, c;
// 	local Effects Sprite;

//		if (bDebug)	log ("Calculation started.");
		Z = TargetLocation - GunLocation;
//		if (bDebug)	log("Z =" @ Z);
		V = TargetVelocity;
//		if (bDebug)	log("V =" @ V);
		a = Z dot Z;	//)/(ProjectileSpeed ** 2);
//		if (bDebug)	log("a =" @ a);
		b = 2*(V dot Z); //)/ProjectileSpeed;
//		if (bDebug)	log("b =" @ b);
		c = (V dot V)-(UseProjectileSpeed ** 2); ///(ProjectileSpeed) - 1;
//		if (bDebug)	log("c =" @ c);
		kA = (-b + ((b**2 - 4*a*c) ** 0.5)) / (2*a);
//		if (bDebug)	log("kA =" @ kA);
		IntDirA = (kA*Z + V)/UseProjectileSpeed;
//		if (bDebug)	log("IntDirA =" @ IntDirA);
		kB = (-b - ((b**2 - 4*a*c) ** 0.5)) / (2*a);
//		if (bDebug)	log("kB =" @ kB);
		IntDirB = (kB*Z + V)/UseProjectileSpeed;
//		if (bDebug)	log("IntDirB =" @ IntDirB);
//		if (bDebug)	log ("Calculation finished.");
		//if (VSize((IntDirA+GunLocation) - (TargetVelocity+TargetLocation)) < VSize((IntDirB+GunLocation) - (TargetVelocity+TargetLocation)))	
		IntDir = IntDirA;
		//else
		//	IntDir = IntDirB;
	
// 		Sprite=Spawn(class'BowenSpriteFlat',,,Location+IntDir,Rotator(IntDir));
// 		Sprite.LifeSpan=VSize(IntDir)/UseProjectileSpeed;
// 		Sprite.Texture=Texture'AlarmLightTex1';
	
		if((VSize(IntDir) == 0) || (VSize(IntDir) > 3*MaxRange && MaxRange != 0))
			return (normal(-Z));
		else
			return (normal(IntDir));

}
/*
static final function vector ObfscCalcIntercept (vector GunLocation, vector TargetLocation, vector TargetVelocity, float UseProjectileSpeed, optional bool bDebug)
{
	return (normal(((((-2*(TargetVelocity dot (TargetLocation - GunLocation))+(((TargetVelocity dot (TargetLocation - GunLocation))**(4*((TargetLocation - GunLocation) dot (TargetLocation - GunLocation))*((TargetVelocity dot TargetVelocity)-(UseProjectileSpeed ** 2))**0.5)/2*((TargetLocation - GunLocation) dot (TargetLocation - GunLocation))) * (TargetLocation - GunLocation) + TargetVelocity)));
}*/

/*
function vector EstimateTrajectory(vector TargetLocation, vector TargetVelocity)
{

	return (TargetLocation + TargetVelocity*VSize(Target

}
*/

function Fire()
{
	local Vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local Rotator rot, destRot;
	local Actor hit;
	local ShellCasing shell;
	local Spark spark;
	local Pawn attacker;
	local DeusExProjectile Proj;
	local float NewProjectileSpeed, UseProjSpeed;
	local effects Sprite;

	if (!gun.IsAnimating())
		gun.LoopAnim('Fire');

	// CNN - give turrets infinite ammo
//	if (ammoAmount > 0)
//	{
//		ammoAmount--;
		GetAxes(gun.Rotation, X, Y, Z);
		StartTrace = gun.Location;
		EndTrace = StartTrace + gunAccuracy * (FRand()-0.5)*Y*1000 + gunAccuracy * (FRand()-0.5)*Z*1000 ;
		EndTrace += 10000 * X;
		hit = Trace(HitLocation, HitNormal, EndTrace, StartTrace, True);

		MakeNoise(1.0);
		PlaySound(sound'DeusExSounds.Weapons.FlamethrowerFire', SLOT_None);
		AISendEvent('LoudNoise', EAITYPE_Audio);

		// muzzle flash
		gun.LightType = LT_Steady;
		gun.MultiSkins[2] = Texture'FlatFXTex34';
		SetTimer(0.1, False);

			if (spark != None)
			{
				spark.DrawScale = 0.05;
				PlayHitSound(spark, hit);
			}

			attacker = None;
			if ((curTarget == hit) && !curTarget.IsA('PlayerPawn'))
				attacker = GetPlayerPawn();
         if (Level.NetMode != NM_Standalone)
            attacker = safetarget;
			if ( hit.IsA('DeusExPlayer') && ( Level.NetMode != NM_Standalone ))
				DeusExPlayer(hit).myTurretKiller = Self;
			//hit.TakeDamage(gunDamage, attacker, HitLocation, 1000.0*X, 'AutoShot');
			if (Level.NetMode == NM_StandAlone)
				Attacker = None;
			
			if (bFireInterceptor)
			{
			//	UseProjSpeed = InterceptorSpeed;
			//	DestRot = Rotator(CalcIntercept(Gun.Location, CurTarget.Location, CurTarget.Velocity, UseProjSpeed, MaxRange, bDebug));
			//	Proj = spawn(InterceptorClass,attacker,,Gun.Location + gun.collisionradius*normal(vector(DestRot)), DestRot); // never miss
				Proj = spawn(InterceptorClass,attacker,,Gun.Location + gun.collisionradius*normal(vector(gun.rotation)), Gun.Rotation);
				NewProjectileSpeed = InterceptorSpeed;
			}
			else
			{
				Proj = spawn(ProjectileClass,attacker,,Gun.Location + gun.collisionradius*normal(vector(gun.rotation)), Gun.Rotation);
				NewProjectileSpeed=ProjectileSpeed;
			}

			bFireInterceptor = False;

			if (Proj != None)
			{
				Proj.Speed = NewProjectileSpeed;
				Proj.MaxSpeed = NewProjectileSpeed;
				Proj.Default.MaxSpeed = NewProjectileSpeed;
				Proj.Default.Speed = NewProjectileSpeed; // The projectile _WILL_ go at the speed I set it at! :@
				Proj.Instigator = Attacker;
				Proj.ItemName = TitleString;
				Proj.ItemArticle="The";
				log ("Fired. Proj=" $ Proj $ ", Owner=" $ Proj.Owner); 
			}

			/*if (hit.IsA('Pawn') && !hit.IsA('Robot'))
				SpawnBlood(HitLocation, HitNormal);
			else if ((hit == Level) || hit.IsA('Mover'))
				SpawnEffects(HitLocation, HitNormal, hit);*/
	//	}
//	}
//	else
//	{
//		PlaySound(sound'DryFire', SLOT_None);
//	}
}

function PreBeginPlay()
{
	local Vector v1, v2;
	local class<AutoTurretGun> gunClass;
	local Rotator rot;

	//Super.PreBeginPlay();

	/*if (IsA('AutoTurretSmall'))
		gunClass = class'AutoTurretGunSmall';
	else*/
		gunClass = class'ProjectileTurretGun';

	RelevantRadius = MaxRange*1.1;

	if (Level.NetMode == NM_StandAlone)
		bAlwaysRelevant=True;

	rot = Rotation;
	rot.Pitch = 0;
	rot.Roll = 0;
	origRot = rot;
	gun = Spawn(gunClass, Self,, Location, rot);
	if (gun != None)
	{
		v1.X = 0;
		v1.Y = 0;
		v1.Z = CollisionHeight + gun.Default.CollisionHeight;
		v2 = v1 >> Rotation;
		v2 += Location;
		gun.SetLocation(v2);
		gun.SetBase(Self);
	}

	// set up the alarm listeners
	AISetEventCallback('Alarm', 'AlarmHeard');

	if ( Level.NetMode != NM_Standalone )
	{
		maxRange = mpTurretRange;
		gunDamage = mpTurretDamage;
		bInvincible = True;
      bDisabled = !bActive;
	}
	targetingLaser = Spawn(class'LaserEmitter',,,Gun.Location+vect(0,0,10),Gun.Rotation);
}
	
function Actor AcquireMultiplayerTarget()
{
	findPlayer();
	return curTarget;
}

function Actor traceForActor(vector StartTrace, vector direction)
{
		local Vector HitLocation, HitNormal, EndTrace, X, Y, Z;
	local Actor hit;
	EndTrace=StartTrace+65536*normal(direction);
	return Trace(HitLocation, HitNormal, EndTrace, StartTrace, True);
}
	
function bool projWillHitMe(DeusExProjectile proj)
{
	local float Deviation;
	if (proj == none || vSize(proj.velocity) <= 0) return false;
	Deviation=ACos(normal(proj.velocity) dot normal(location - proj.location));
//	BroadcastMessage("Deviation=" $ Deviation);
	return (Deviation < 0.1);
}
	
static final function float ACos  ( float A )
{
		if (A>1||A<-1) //outside domain!
			return 0;
	if (A==0) //div by 0 check
			return (Pi/2.0);
	A=ATan(Sqrt(1.0-Square(A))/A);
	if (A<0)

			A+=Pi;
	Return A;
}
	
//---END-CLASS---
defaultproperties
{
    bInterceptPriority=True
    ProjectileSpeed=1000.00
    InterceptorSpeed=5000.00
    InterceptorRate=1.20
    Tolerance=1.00
    bTrackProjectiles=True
    bInterceptThreatsOnly=True
    ProjectileClass=Class'DeusEx.RocketMini'
    InterceptorClass=Class'InterceptorMissile'
    titleString="Bowen ProjectileTurret"
    bTrackPawnsOnly=True
    maxRange=4096
    fireRate=1.00
    pitchLimit=32768.00
    mpTurretRange=4096
    HitPoints=200
    minDamageThreshold=150
    bStasis=False
}
