//=============================================================================
// ProxDisc. 	(c) 2003 JimBowen
//=============================================================================
class ProxDisc extends ExplosiveDisc;

var(Bowen) float ProxRadius, SpawnPointCheckRadius;
var(Bowen) int MaxAreaDiscs, MaxTotalDiscs, mpMaxAreaDiscs, mpMaxTotalDiscs;
var bool bDoneMsg;

auto simulated state flying
{
	simulated function ProcessTouch(Actor Other, Vector HitLocation)
	{
		if (Other == Owner)
			return;
		if (Owner.IsA('DeusExPlayer') && Other.IsA('DeusExPlayer')) 
			if (TeamDMGame(DeusExPlayer(Owner).DXGame) != None)	
				if (DeusExPlayer(Other).PlayerReplicationInfo.Team == Team)
					return;
			
		DrawType = DT_None;
		bBlockActors = false;
		bBlockPlayers = false;
		BlowUpActor = Other;
		Detonate();
	}
	
	
	simulated function HitWall(vector HitNormal, actor Wall)
	{
		local proxdisc disc;
		local proxdisc FirstDisc;
		local PlayerStart Spawn;
		local SpawnExtension SpawnExt;
		local int i;
			
			
		SetCollisionSize(ProxRadius, ProxRadius);
		Super.HitWall(HitNormal, Wall);
		
		if (Level.NetMode == NM_Standalone)
			return;

			
			foreach RadiusActors (class 'PlayerStart', Spawn, SpawnPointCheckRadius)
			{
				if (FastTrace(Spawn.Location, Location) && !bDoneMsg)// only do this once, and if we can see the spawn
				{
					if (Owner.IsA('DeusExPlayer'))
					{
						DeusExPlayer(Owner).ClientMessage("Prox discs are not allowed in spawn rooms");
						log("ProxDisc placed in spawn room by " $ DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName $ "!");
					}
					else log ("ProxDisc was found in spawn room with no player owner");
					SpawnSmoke();
					bDoneMsg = True;
					Destroy();
				}
			}

			foreach RadiusActors (class 'SpawnExtension', SpawnExt, SpawnPointCheckRadius)
			{
				if (FastTrace(SpawnExt.Location, Location) && !bDoneMsg)// only do this once, and if we can see the spawn
				{
					if (Owner.IsA('DeusExPlayer'))
					{
						DeusExPlayer(Owner).ClientMessage("Prox discs are not allowed in spawn rooms");
						log("ProxDisc placed in spawn room by " $ DeusExPlayer(Owner).PlayerReplicationInfo.PlayerName $ "!");
					}
					else log ("ProxDisc was found in spawn room with no player owner");
					SpawnSmoke();
					bDoneMsg = True;
					Destroy();
				}
			}
			
			bAlwaysRelevant=true;
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
}


defaultproperties
{
    proxRadius=20.00
    SpawnPointCheckRadius=400.00
    MaxAreaDiscs=64
    MaxTotalDiscs=1024
    mpMaxAreaDiscs=10
    mpMaxTotalDiscs=60
    Health=80
    mpHealth=80
    mpDamage=130
    ItemName="proximity disc"
    Skin=Texture'Editor.Bkgnd'
    MultiSkins=Texture'DeusExUI.UserInterface.ConWindowActiveBackground'
}
