//=============================================================================
// RadLight. 	(c) 2003 JimBowen
//=============================================================================
class RadLight expands Light;

var float hurtTimer;
var (Bowen) bool bHurtRadius;

simulated function Tick(float deltatime)
{
	local float NewBrightness;
	local pawn p;


		hurtTimer += DeltaTime;
		if (hurtTimer > 1 && bHurtRadius)
		{
			hurtTimer = 0;
			HurtRadius (0, 200, 'Radiation', 0, Location, False);
		}

		NewBrightness = int(FMin((3*(LifeSpan /Default.LifeSpan) * Default.LightBrightness), Default.LightBrightness));
		
		if (NewBrightness >= 2)
		{
			LightBrightness = int(NewBrightness);
			VolumeBrightness=LightBrightness;
		}
		else
		{
			LightBrightness = 0;
			LightType = LT_None;
			Destroy();
		}


	Super.Tick(DeltaTime);
}

//---END-CLASS---

defaultproperties
{
    bHurtRadius=True
    bStatic=False
    bNoDelete=False
    bMovable=True
    LifeSpan=10.00
    LightType=7
    LightBrightness=192
    LightHue=59
    LightSaturation=159
    LightRadius=16
    LightPeriod=50
    LightPhase=30
    VolumeBrightness=16
    VolumeRadius=3
    VolumeFog=4
}
