class RingTracer extends Tracer;

var float size;

simulated function Tick(float deltaTime)
{
	Super.Tick(DeltaTime);
	DrawScale = size * (Default.LifeSpan - LifeSpan) / Default.LifeSpan;
	ScaleGlow = LifeSpan / Default.LifeSpan;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	if (size > 5)
		Skin = Texture'FlatFXTex43';
}

defaultproperties
{
    size=3.00
    speed=1000.00
    LifeSpan=0.25
    Style=3
    Skin=Texture'DeusExItems.Skins.FlatFXTex41'
    Mesh=LodMesh'DeusExItems.FlatFX'
    bCollideActors=False
    bCollideWorld=False
}
