class RiotGun extends BowenWeapon;

var (Bowen) float ForceStrength, UpwardMotionCoeff, ForwardMotionCoeff, OutwardMotionCoeff, WaveSpread, chargeRate;
var (Bowen) byte minSoundPitch, maxSoundPitch;
var (Bowen) Sound chargingSound, stunBombSound;
var bool bCharging;

replication
{
	reliable if(Role == ROLE_Authority)
		tryAltFire;
}


simulated function DrawEffects()
{
	local RingTracer Eff;

		Eff = Spawn(class'RingTracer',,, Owner.Location + vect(0,0,1)*Pawn(Owner).BaseEyeHeight, Pawn(Owner).ViewRotation);
		Eff.Size = 6;
	//	Pawn(Owner).ClientMessage("DrawEffects()");
	//	Eff.Skin = Texture'DeusExDeco.Skins.EidoslogoTex1';
	//	Eff.LifeSpan = 0.5;
	//DeusExPlayer(Owner).ConsoleCommand("Summon BowenTest.RingTracer");
}
/*
simulated function SimGenerateBullet()
{
//	Super.ClientFire(Value);
//	DeusExPlayer(Owner).ClientMessage("ClientFire()");
	DrawEffects();
	Super.SimGenerateBullet();
}
*/
simulated function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	//b0rk
}

simulated function TraceFire( float Accuracy )
{
	local vector VelocityToSet;
	local float adj;
	local vector Outwards;
	local actor a;
	local float fangle;
	local vector vvect, dvect;

	Super.TraceFire(Accuracy);
	DrawEffects();
	
	foreach visibleactors (class 'Actor', a, MaxRange)
	{
		if (a == none || a.IsInState('Dying'))
			continue;
		if (a.IsA('DeusExPlayer') && TeamDMGame(DeusExPlayer(Owner).DXGame) != None)
			if ((DeusExPlayer(a).PlayerReplicationInfo.Team == DeusExPlayer(Owner).PlayerReplicationInfo.Team) && a != Owner)
				continue;

		vvect = vector(Pawn(Owner).ViewRotation);
		dvect = normal(a.Location - Owner.Location);
		fangle = Acos(vvect dot dvect);
		if (fangle < WaveSpread)
		{
			Outwards=dVect;
			VelocityToSet=UpwardMotionCoeff*vect(0,0,1) + ForwardMotionCoeff*normal(vector(Pawn(Owner).ViewRotation)) + OutwardMotionCoeff*Outwards;
			VelocityToSet *= ForceStrength / fmax(MaxRange/5,vsize(dVect));
			if(a.location.z > owner.location.z + 100)
				VelocityToSet.z = 0;
	/*		adj = MaxRange/VSize(a.Location - Owner.Location);
			VelocityToSet = adj*normal(a.Location - Owner.Location)*ForceStrength*ForwardMotionCoeff;
			VelocityToset.z = ForceStrength*adj;
		*/
	//		VelocityToSet += ((HitNormal * MaxRange) / dist**1.3) * ForceStrength/3;

		//	a = Owner;

			if (a.IsA('PlayerPawn'))
			{
				a.setPhysics(PHYS_Falling);
				a.Velocity += VelocityToSet;
			}
			else if (a.IsA('ScriptedPawn'))
			{
				a.SetPhysics(PHYS_Falling);
				a.Velocity += VelocityToSet;
				//ScriptedPawn(a).ImpartMomentum((VelocityToSet * 6000), Pawn(Owner));
				a.goToState('FallingState');
			}
			else if (a.isA('DeusExDecoration'))
			{
				if (DeusExDecoration(a).bPushable)
				{
					a.SetPhysics(PHYS_Falling);
					a.Velocity += (VelocityToSet * 800)/a.Mass;
				}
			}
			else if (a.IsA('Carcass'))
			{	a.SetPhysics(PHYS_Falling);
				a.Velocity += (VelocityToSet * 800)/a.Mass;
			}
		}
	}
}

simulated function ScopeToggle()
{
	// hack so that players without configured ini files can still use the weapon
	// yes i know its ugly, but you think of a better way!
	if(tryAltFire())
		goToState('stunBomb');
}

function bool tryAltFire()
{
	if(isInState('stunBomb'))
		return false;
	if(ammoLeftInClip() == reloadCount) // only with a full clip
	{
		SoundPitch=MinSoundPitch;
		AmbientSound = chargingSound;
		return true;
	}
	else
	{
		Owner.PlaySound (Sound'DeusExSounds.Generic.Buzz1', SLOT_None, 1024);
		return false;
	}
}

simulated state stunBomb
{
	function Fire(float value)
	{
		// do nothing, can't fire while charging
	}
	simulated function timer()
	{
		if(bCharging)
		{
			if(ammoLeftInClip() > 0)
			{
				ammoType.useAmmo(1);
				clipCount++;
				DeusExPlayer(Owner).clientMessage("Charging: " $ ammoLeftInClip());
				SoundPitch = byte(float(minSoundPitch) + float(maxSoundPitch)*(float(reloadCount - ammoLeftInClip()) / float(reloadCount)));
			}
			else // charging complete
			{
				bCharging = False;
				doStunBomb();
			}
		}
	}
	simulated function doStunBomb()
	{
		local pawn p;
		local float fangle;
		local vector vvect, dvect;
		
		SpawnStunEffects();
		Owner.PlaySound (StunBombSound, SLOT_None, 1024);
		for(p=Level.PawnList; p != None; p=p.nextPawn)
		{
			vvect = vector(Pawn(Owner).ViewRotation);
			dvect = normal(p.Location - Owner.Location);
			fangle = Acos(vvect dot dvect);
			if (fangle < WaveSpread && vSize(p.Location - Owner.Location) < MaxRange*3)
			{
				if(p.isA('ScriptedPawn'))
					p.takeDamage(HitDamage,Pawn(Owner),p.Location,vect(0,0,1),'Stunned');
				else if (p.isA('DeusExPlayer'))
					DeusExPlayer(p).ClientFlash(2, vect(1000,1000,1000));
			}
		}
		reloadAmmo();
		endState();
		AmbientSound=None;
		SoundPitch=MinSoundPitch;
	}


	begin:
		bCharging = true;
		setTimer(chargeRate, True);
		
}


static final function float ACos  ( float A )	// thanks to UnrealWiki for this
{
  if (A>1||A<-1) //outside domain!
    return 0;
  if (A==0) //div by 0 check
    return (Pi/2.0);
  A=ATan(Sqrt(1.0-Square(A))/A);
  if (A<0)

    A+=Pi;
  Return A;
}

simulated function SpawnStunEffects()
{
	local particleGenerator gen;
	local SphereEffect sphere;
	local explosionLight light;
	
	gen = Spawn(class'ParticleGenerator', Self);
	if (gen != None)
	{
		gen.particleTexture = Texture'Effects.Smoke.SmokePuff1';
		gen.particleDrawScale = 5.5;
		gen.checkTime = 0.03;
		gen.riseRate = 1.0;
		gen.ejectSpeed = 1000.0;
		gen.particleLifeSpan = 1.0;
		gen.bRandomEject = True;
		gen.lifeSpan=1.0;
		gen.setRotation(Pawn(Owner).ViewRotation);
      gen.RemoteRole = ROLE_None;
	}
	sphere = Spawn(class'SphereEffect',,, Owner.Location);
	if (sphere != None)
   {
      sphere.RemoteRole = ROLE_None;
		sphere.size = 100;
   }
	light = Spawn(class'ExplosionLight',,, Owner.Location);
	if (light != None)
	{
      light.RemoteRole = ROLE_None;
		light.size = 8;
		light.LightHue = 128;
		light.LightSaturation = 96;
		light.LightEffect = LE_Shell;
	}
}

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
		ReloadCount = mpReloadCount;
	}
}

defaultproperties
{
    ForceStrength=1000.00
    UpwardMotionCoeff=2.00
    ForwardMotionCoeff=3.00
    OutwardMotionCoeff=1.00
    WaveSpread=0.50
    chargeRate=0.06
    minSoundPitch=100
    maxSoundPitch=191
    chargingSound=Sound'DeusExSounds.Robot.SpyBotMove'
    stunBombSound=Sound'DeusExSounds.Weapons.EMPGrenadeExplode'
    LowAmmoWaterMark=40
    GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
    NoiseLevel=0.05
    EnemyEffective=1
    EnviroEffective=4
    Concealability=1
    bAutomatic=True
    ShotTime=0.20
    reloadTime=3.00
    HitDamage=115
    maxRange=300
    AccurateRange=200
    bPenetrating=False
    bHasMuzzleFlash=False
    mpReloadTime=3.00
    mpHitDamage=15
    mpBaseAccuracy=0.50
    mpAccurateRange=200
    mpMaxRange=300
    mpReloadCount=32
    AmmoName=Class'AmmoRiot'
    ReloadCount=32
    PickupAmmoCount=128
    bInstantHit=True
    FireOffset=(X=-21.00,Y=12.00,Z=19.00),
    shakemag=20.00
    FireSound=Sound'DeusExSounds.Weapons.ProdFire'
    AltFireSound=Sound'DeusExSounds.Weapons.ProdReloadEnd'
    CockingSound=Sound'DeusExSounds.Weapons.ProdReload'
    SelectSound=Sound'DeusExSounds.Weapons.ProdSelect'
    InventoryGroup=192
    ItemName="Riot supressor"
    PlayerViewOffset=(X=21.00,Y=-12.00,Z=-19.00),
    PlayerViewMesh=LodMesh'DeusExItems.Prod'
    PickupViewMesh=LodMesh'DeusExItems.ProdPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.Prod3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconProd'
    largeIcon=Texture'DeusExUI.Icons.LargeIconProd'
    largeIconWidth=49
    largeIconHeight=48
    Description="The BowenCo riot supressor creates an EM wave that will create sudden muscle spasms in the subject, causing them to violently hurl themselves out of the way. This is combined with a pneumatic pressure wave that can deflect projectiles and assist in removing the subject from the user's path, leaving the subject dazed and confused. It is invaluable in dispersing large groups of rioters."
    beltDescription="RIOT"
    Mesh=LodMesh'DeusExItems.ProdPickup'
    CollisionRadius=8.75
    CollisionHeight=1.35
}
