//=============================================================================
// SpiralGun.
//=============================================================================
class SpiralGun extends DeusExWeapon;

var (Bowen) int numRockets;		// how many rockets per shot
var (Bowen) float Radius;		// exact radius (scalar) of the helix
var (Bowen) float Frequency;		// frequency: rocket revolutions/sec
var (Bowen) bool bDebug;		// log debug output
var (Bowen) float Angle;

simulated function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local HelixRocket H;
	local Projectile P;
	local vector RVectA, RVectB;
	local int i;
	local vector Omega, dR, vR, pR; // angular freq, radial direction, radial velocity
					//	, radial position (relative to helix axis)

	for (i=0;i<numRockets;i++)
	{
		P = Super.ProjectileFire(ProjClass, ProjSpeed, bWarn);
		
		if (HelixRocket(P) != None)
		{
			H = HelixRocket(P);

			//first make a couple of perpendicular vectors on the plane
			// infront of the player and perpendicular to his ViewRotation
			RVectA = Angle * H.Speed * vect(0,0,1);
			RVectB = Angle * H.Speed * normal(vect(0,0,1) cross H.Velocity);

			Omega = 2*pi*Frequency*normal(H.Velocity);
			dR = normal(	RVectA * cos((2*pi*i)/NumRockets) +
					RVectB * sin((2*pi*i)/NumRockets));
			pR = dR * Radius;
			vR = pR cross Omega;

			H.OrigVelocity = H.Velocity;
			H.Velocity += vR;
			H.vR = vR;
			H.pR = pR;
			H.Omega = Omega;
			H.ID = i;

			H.SetLocation(H.Location + pR);
			H.SmokeGen.SetBase(H);
			H.FireGen.SetBase(H);

			if(bDebug)
			{
				Log("*******FIRED A HELIXROCKET******", 'DEBUG');
				Log("pR = " $ pR);
				Log("vR = " $ vR);
				Log("dR = " $ dR);
				Log("Omega = " $ Omega);
			}
		}
	}
	return P;
}

defaultproperties
{
    NumRockets=3
    Radius=50.00
    Frequency=2.00
    bDebug=True
    angle=0.08
    LowAmmoWaterMark=4
    GoverningSkill=Class'DeusEx.SkillWeaponHeavy'
    NoiseLevel=2.00
    EnviroEffective=1
    ShotTime=2.00
    reloadTime=2.00
    HitDamage=300
    maxRange=24000
    AccurateRange=14400
    bCanHaveScope=True
    bCanTrack=True
    LockTime=2.00
    LockedSound=Sound'DeusExSounds.Weapons.GEPGunLock'
    TrackingSound=Sound'DeusExSounds.Weapons.GEPGunTrack'
    bHasMuzzleFlash=False
    recoilStrength=1.00
    bUseWhileCrouched=False
    bCanHaveModAccurateRange=True
    bCanHaveModReloadTime=True
    AmmoName=Class'AmmoSpiral'
    ReloadCount=1
    PickupAmmoCount=4
    FireOffset=(X=-46.00,Y=22.00,Z=10.00),
    ProjectileClass=Class'HelixRocket'
    shakemag=500.00
    FireSound=Sound'DeusExSounds.Weapons.GEPGunFire'
    CockingSound=Sound'DeusExSounds.Weapons.GEPGunReload'
    SelectSound=Sound'DeusExSounds.Weapons.GEPGunSelect'
    InventoryGroup=27
    ItemName="Spiral rocket launcher"
    PlayerViewOffset=(X=46.00,Y=-22.00,Z=-10.00),
    PlayerViewMesh=LodMesh'DeusExItems.GEPGun'
    PickupViewMesh=LodMesh'DeusExItems.GEPGunPickup'
    ThirdPersonMesh=LodMesh'DeusExItems.GEPGun3rd'
    LandSound=Sound'DeusExSounds.Generic.DropLargeWeapon'
    Icon=Texture'DeusExUI.Icons.BeltIconGEPGun'
    largeIcon=Texture'DeusExUI.Icons.LargeIconGEPGun'
    largeIconWidth=203
    largeIconHeight=77
    invSlotsX=4
    invSlotsY=2
    Description="The Spiral rocket launcher fires a number of rockets in a tight spiral to confuse anti-missile systems."
    beltDescription="SPIRAL"
    Mesh=LodMesh'DeusExItems.GEPGunPickup'
    CollisionRadius=27.00
    CollisionHeight=6.60
    Mass=50.00
}
