//=============================================================================
// WLD.	(c) 2003 JimBowen
//=============================================================================
class WLD expands BowenGrenade;

var localized String shortName;

function PostBeginPlay()
{
   Super.PostBeginPlay();
   bWeaponStay=False;
}

// Become a pickup
// Weapons that carry their ammo with them don't vanish when dropped
function BecomePickup()
{
	Super.BecomePickup();
   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 0.0;
}

// ----------------------------------------------------------------------
// TestMPBeltSpot()
// Returns true if the suggested belt location is ok for the object in mp.
// ----------------------------------------------------------------------

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 6);
}


//---END-CLASS---

defaultproperties
{
    ShortName="Locator"
    LowAmmoWaterMark=2
    GoverningSkill=Class'DeusEx.SkillDemolition'
    EnviroEffective=4
    Concealability=3
    ShotTime=0.30
    reloadTime=0.10
    HitDamage=50
    maxRange=4800
    AccurateRange=2400
    BaseAccuracy=0.00
    bHasMuzzleFlash=False
    bHandToHand=True
    bUseAsDrawnWeapon=False
    AITimeLimit=3.50
    AIFireDelay=5.00
    bNeedToSetMPPickupAmmo=False
    mpReloadTime=0.10
    mpHitDamage=50
    mpBaseAccuracy=1.00
    mpAccurateRange=2400
    mpMaxRange=2400
    AmmoName=Class'AmmoLD'
    ReloadCount=1
    PickupAmmoCount=1
    FireOffset=(X=0.00,Y=10.00,Z=20.00),
    ProjectileClass=Class'BounceBombBeacon'
    shakemag=50.00
    SelectSound=Sound'DeusExSounds.Weapons.NanoVirusGrenadeSelect'
    InventoryGroup=241
    ItemName="Locator Drone"
    PlayerViewOffset=(X=24.00,Y=-15.00,Z=-19.00),
    PlayerViewMesh=LodMesh'DeusExItems.NanoVirusGrenade'
    PickupViewMesh=LodMesh'DeusExItems.NanoVirusGrenadePickup'
    ThirdPersonMesh=LodMesh'DeusExItems.NanoVirusGrenade3rd'
    Icon=Texture'DeusExUI.Icons.BeltIconWeaponNanoVirus'
    largeIcon=Texture'DeusExUI.Icons.LargeIconWeaponNanoVirus'
    largeIconWidth=24
    largeIconHeight=49
    Description="The BowenCo Locator roams an area looking for hostiles, before attaching itself to the first one it finds. Once attached it boroadcasts the target"
    beltDescription="LOCATOR"
    Mesh=LodMesh'DeusExItems.NanoVirusGrenadePickup'
    CollisionRadius=3.00
    CollisionHeight=2.43
    Mass=5.00
    Buoyancy=2.00
}
