// A thing for triggering movers to close shut forever and be invincible,
//	if the server game is zero augs, to cover up biobots etc. -Nax 12.3.2018
//		Use the tag 'noaugmov' on movers you want to be affected by this.
//
Class NoAugTrig extends Mutator;

var() float CheckTime;
var() Name trigTag;
var() bool bZeroAugGame;
var() bool bAuggingGame;

/*
TY to Cozmo for this checking wotsit.
	
	if ( (Level.Game.InitialAugs == 0) && (Level.Game.AugsPerKill == 0) )
	
thanks to Lexichu for a version that checks it's a DXMPGame.

	local DeusExMPGame mpGame;
	
	mpGame = DeusExMPGame(Level.Game);
	if(mpGame != None)
	{
		bAugMPGame = (mpGame.augsPerKill > 0 || mpGame.InitialAugs > 0)
	}
	
Made it more strict just incase.

USAGE:
Go into your DeusEx.ini file. Find the section that starts with '[DeusEx.DeusExGameEngine]'
Add the line 'ServerActors=MoverTrig.NoAugTrig' under the "UseSound=" line.
If it does not work with just that line, add 'ServerPackages=MoverTrig' at the end of the section.

Mapping Example:
Start your mover (that covers up a bio-bot house, or whatever) below the ground, 
it will be triggered at the start of a map, move to cover the bot, and wont be activatable again!
*/

function postbeginplay()
{
	local DeusExMPGame dxg;
	
	Super.postbeginplay();
	
	dxg = DeusExMPGame(Level.Game);
	if((Level.NetMode != NM_Standalone) && (dxg != None))
	{
		bAuggingGame = (dxg.SkillsTotal > 0) ||(dxg.SkillsAvail > 0) || (dxg.SkillsPerKill > 0) || (dxg.InitialAugs > 0) && (dxg.AugsPerKill > 0) || (dxg.MPSkillStartLevel < 3);
		bZeroAugGame = (dxg.SkillsTotal == 0) || (dxg.SkillsAvail == 0) || (dxg.SkillsPerKill == 0) || (dxg.InitialAugs == 0) && (dxg.AugsPerKill == 0) || (dxg.MPSkillStartLevel == 3);
	}
	
	if (bZeroAugGame)
		SetTimer(CheckTime, False);
	else
		Return;
}

function Timer()
{
	TriggerMovers();
}

function TriggerMovers()
{
	local DeusExMover DXM;
	
	foreach AllActors(class'DeusExMover', DXM)
	{
		if ( (DXM != None) && (DXM.class != Class'BreakableWall') && (DXM.class != Class'BreakableGlass') )
		{
			if ((DXM.Tag != '') && (DXM.Tag == trigTag))
			{
				if (DXM.bFrobbable)
					DXM.bFrobbable = False;
					
				if (DXM.bLocked)
					DXM.bLocked = False;
					
				if (DXM.bBreakable)
					DXM.bBreakable = False;
					
				if (DXM.bPickable)
					DXM.bPickable = False;
					
			// DXM.OpeningSound = None;
			// DXM.OpenedSound = None;
			// DXM.ClosingSound = None;
			// DXM.ClosedSound = None;
			// DXM.MoveAmbientSound = None;
				
				if (DXM.MoveTime > 0.0001)
					DXM.MoveTime = 0.0001;
					
				if (DXM.DelayTime > 0.0001)
					DXM.DelayTime = 0.0001;
					
				// Log("NoAugTrig: Mover triggered!");
				
				DXM.Trigger(self, None);
			}
		}
	}
}

defaultproperties
{
	CheckTime=2.0
	trigTag=noaugmov
	bhidden=true
}