/*=============================================================================
	Cluster.h: Cluster audio public header file.
	Copyright 1997-1999 Epic Games, Inc. All Rights Reserved.
	Copyright 2015 Sebastian Kaufel. All Rights Reserved.
=============================================================================*/

#ifndef _INC_CLUSTER
#define _INC_CLUSTER

/*-----------------------------------------------------------------------------
	Dependencies.
-----------------------------------------------------------------------------*/

#include <AL/al.h>
#include <AL/alc.h>
#include <AL/alext.h>

#include <mikmod.h>

#include "Engine.h"
#include "UnRender.h"

/*-----------------------------------------------------------------------------
	Preprocessor macros.
-----------------------------------------------------------------------------*/

#ifdef DEBUG_SOUND
	#define debugSoundf debugf
#else
	#define debugSoundf GNull->Logf
#endif

/*-----------------------------------------------------------------------------
	Global variables.
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
	Global functions.
-----------------------------------------------------------------------------*/

// Wrapper around al[c]GetString.
FString ALErrorString( ALenum ErrorCode );
FString ALCErrorString( ALCdevice* Device, ALCenum ErrorCode );

FString ALCurrentErrorString();
FString ALCCurrentErrorString( ALCdevice* Device );

// Actually the better approach would be to just put this into GLog->Serialize
// or GLog->Log and expect a launcher which can handle it.
inline void SafePrint( EName Tag, TCHAR* Prefix, ANSICHAR* Str )
{
	guard(SafePrint);
	ANSICHAR Temp[1024];
	INT TempLen;
	FString TempString;
	ANSICHAR* LastSpace;
	ANSICHAR* ALString = Str;
	INT ALStringLen = strlen( ALString );

	while ( ALStringLen > 0 )
	{
		strncpy(Temp,ALString,960);
		Temp[960]    = 0;
		TempLen      = strlen( Temp );
		if ( TempLen < 960 )
		{
			debugf( Tag, TEXT("%s%s"), Prefix, appFromAnsi( Temp ) );
			break;
		}
		else
		{
			LastSpace  = (ANSICHAR*)strrchr( Temp, ' ' );
			*LastSpace = 0;
			debugf( Tag, TEXT("%s%s"), Prefix, appFromAnsi( Temp ) );
			ALString		+= LastSpace-Temp+1;
			ALStringLen -= LastSpace-Temp+1;
		}
	}
	unguard;
}

/*-----------------------------------------------------------------------------
	Cluster compiler specific includes.
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
	Cluster public includes.
-----------------------------------------------------------------------------*/

#include "MikModInterface.h"
#include "ClusterDeviceContext.h"
#include "ClusterSubsystem.h"

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/
#endif //_INC_CLUSTER

