/*=============================================================================
	ClusterDeviceContext.h: Cluster device context handling public header file.
	Copyright 2015 Sebastian Kaufel. All Rights Reserved.

Revision history:
	* Created by Sebastian Kaufel.
=============================================================================*/

/*-----------------------------------------------------------------------------
	FClusterDeviceContext.
-----------------------------------------------------------------------------*/

class FClusterDeviceContext
{
	// Structures.
	struct FContextAttribute
	{
		// Constructors.
		FContextAttribute()
		: Attribute(0)
		, Value(0)
		{}
		FContextAttribute( ALCint InAttribute, ALCint InValue )
		: Attribute(InAttribute)
		, Value(InValue)
		{}

		// Operators.
		// The comparison operators just checks Attribute and NOT the value.
		// This is intended so i can use AddUniqueItem on the TArrays.
		UBOOL operator==( const FContextAttribute &Other ) const
		{
			return Attribute==Other.Attribute;
		}

		// Variables.
		ALCint Attribute;
		ALCint Value;
	};

	// Variables.
	UBOOL Initialized;
	ALCdevice*  Device;
	ALCcontext* Context;
	TArray<FContextAttribute> ContextAttributes;
	TArray<ALCchar> DeviceName;

public:
	FClusterDeviceContext()
	: Initialized(0)
	, Device(NULL)
	{}

	// Initializes the device context based on settings specified by 
	// SetContextAttribute/SetDeviceName. If the context is already 
	// initialized it will return false.
	UBOOL Init();

	// Shutsdown the current device context. If the context is not initialized
	// it will also return true.
	UBOOL Shutdown();

	// Accessors.
	UBOOL IsInitialized()
	{
		return Initialized;
	}
	ALCdevice* GetDevice()
	{
		return Device;
	};
	ALCcontext* GetContext()
	{
		return Context;
	}

	// The following functions are intended to be called prior calling Init.
	// They DO not affect an already created context. To apply them you need
	// to shutdown and reeinit the context.
	void SetContextAttribute( ALCint Attribute, ALCint Value );
	void ClearContextAttributes();

	void SetDeviceName( const ALCchar *InDeviceName );
	void ClearDeviceName();
};

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/
