#ifndef HASH_H_
#define HASH_H_

#include <sys/types.h>

#define DEFAULT_HASHSIZE 23

/*
 *  Associative array data type
 */

typedef struct {
	int key;
	void *data;
} h_entry;

typedef struct hash {
    h_entry **table;
    unsigned int items;
    unsigned int capacity; 
} hash;

#ifdef __cplusplus
extern "C" {
#endif

hash    *hash_alloc         (unsigned int initialsize);
hash    *hash_resize        (hash *h, size_t capacityrequest);
hash    *hash_add           (hash *table, h_entry *datum);
hash    *hash_add_first_free(hash *table, h_entry *datum);
hash    *hash_remove        (hash *table, int key);
hash    *hash_delete        (hash *table, int key, void (*freer_func)(void *));
h_entry *hash_get           (hash *table, int key);
void     hash_free          (hash *table, void (*freer_func)(void *));

h_entry *h_entry_alloc(int key, void *newdata);

#ifdef __cplusplus
};
#endif

#endif
